/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.dto.notification.Notification;
import org.jboss.pnc.enums.JobNotificationProgress;
import org.jboss.pnc.enums.JobNotificationType;

public class OperationNotification
extends Notification {
    private final String operationId;
    private final OperationResult result;

    @JsonCreator
    public OperationNotification(String notificationType, String operationId, ProgressStatus newStatus, ProgressStatus oldStatus, OperationResult result) {
        super(JobNotificationType.OPERATION, notificationType, OperationNotification.convert(newStatus), OperationNotification.convert(oldStatus));
        this.operationId = operationId;
        this.result = result;
    }

    @JsonCreator
    public OperationNotification(String notificationType, String operationId, ProgressStatus newStatus, ProgressStatus oldStatus, String message, OperationResult result) {
        super(JobNotificationType.OPERATION, notificationType, OperationNotification.convert(newStatus), OperationNotification.convert(oldStatus), message);
        this.operationId = operationId;
        this.result = result;
    }

    private static JobNotificationProgress convert(ProgressStatus status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case NEW: 
            case PENDING: {
                return JobNotificationProgress.PENDING;
            }
            case IN_PROGRESS: {
                return JobNotificationProgress.IN_PROGRESS;
            }
            case FINISHED: {
                return JobNotificationProgress.FINISHED;
            }
        }
        throw new IllegalArgumentException("Unknown Progress Status.");
    }

    public String getOperationId() {
        return this.operationId;
    }

    public OperationResult getResult() {
        return this.result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationNotification)) {
            return false;
        }
        OperationNotification other = (OperationNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$operationId = this.getOperationId();
        String other$operationId = other.getOperationId();
        if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
            return false;
        }
        OperationResult this$result = this.getResult();
        OperationResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OperationNotification;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $operationId = this.getOperationId();
        result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
        OperationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OperationNotification(operationId=" + this.getOperationId() + ", result=" + this.getResult() + ")";
    }
}

