/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.response;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=Builder.class)
public class Vertex<T> {
    private final String name;
    private final String dataType;
    private final T data;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public T getData() {
        return this.data;
    }

    public Vertex(String name, String dataType, T data) {
        this.name = name;
        this.dataType = dataType;
        this.data = data;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder<T> {
        private String name;
        private String dataType;
        private T data;

        Builder() {
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Vertex<T> build() {
            return new Vertex<T>(this.name, this.dataType, this.data);
        }

        public String toString() {
            return "Vertex.Builder(name=" + this.name + ", dataType=" + this.dataType + ", data=" + this.data + ")";
        }
    }
}

