/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.response;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import java.util.Map;
import org.jboss.pnc.dto.response.Edge;
import org.jboss.pnc.dto.response.Vertex;

@JsonDeserialize(builder=Builder.class)
public class Graph<T> {
    private final Map<String, Vertex<T>> vertices;
    private final List<Edge<T>> edges;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Map<String, Vertex<T>> getVertices() {
        return this.vertices;
    }

    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    public Graph(Map<String, Vertex<T>> vertices, List<Edge<T>> edges) {
        this.vertices = vertices;
        this.edges = edges;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder<T> {
        private Map<String, Vertex<T>> vertices;
        private List<Edge<T>> edges;

        Builder() {
        }

        public Builder<T> vertices(Map<String, Vertex<T>> vertices) {
            this.vertices = vertices;
            return this;
        }

        public Builder<T> edges(List<Edge<T>> edges) {
            this.edges = edges;
            return this;
        }

        public Graph<T> build() {
            return new Graph<T>(this.vertices, this.edges);
        }

        public String toString() {
            return "Graph.Builder(vertices=" + this.vertices + ", edges=" + this.edges + ")";
        }
    }
}

