/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.jboss.pnc.common.validator.NoHtml;
import org.jboss.pnc.dto.AlignmentStrategy;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildConfigurationWithLatestBuild
extends BuildConfiguration {
    private final BuildRef latestBuild;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String latestBuildUsername;

    private BuildConfigurationWithLatestBuild(SCMRepository scmRepository, ProjectRef project, Environment environment, Map<String, BuildConfigurationRef> dependencies, ProductVersionRef productVersion, Map<String, GroupConfigurationRef> groupConfigs, Map<String, String> parameters, String id, String name, String description, String buildScript, String scmRevision, Instant creationTime, Instant modificationTime, BuildType buildType, User creationUser, User modificationUser, String defaultAlignmentParams, Boolean brewPullActive, Set<AlignmentStrategy> alignmentStrategies, BuildRef latestBuild, String latestBuildUsername) {
        super(scmRepository, project, environment, dependencies, productVersion, groupConfigs, parameters, id, name, description, buildScript, scmRevision, creationTime, modificationTime, buildType, creationUser, modificationUser, defaultAlignmentParams, brewPullActive, alignmentStrategies);
        this.latestBuild = latestBuild;
        this.latestBuildUsername = latestBuildUsername;
    }

    public static Builder builderWithLatestBuild() {
        return new Builder();
    }

    public BuildRef getLatestBuild() {
        return this.latestBuild;
    }

    public String getLatestBuildUsername() {
        return this.latestBuildUsername;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfigurationWithLatestBuild)) {
            return false;
        }
        BuildConfigurationWithLatestBuild other = (BuildConfigurationWithLatestBuild)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BuildRef this$latestBuild = this.getLatestBuild();
        BuildRef other$latestBuild = other.getLatestBuild();
        if (this$latestBuild == null ? other$latestBuild != null : !((Object)this$latestBuild).equals(other$latestBuild)) {
            return false;
        }
        String this$latestBuildUsername = this.getLatestBuildUsername();
        String other$latestBuildUsername = other.getLatestBuildUsername();
        return !(this$latestBuildUsername == null ? other$latestBuildUsername != null : !this$latestBuildUsername.equals(other$latestBuildUsername));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BuildConfigurationWithLatestBuild;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuildRef $latestBuild = this.getLatestBuild();
        result = result * 59 + ($latestBuild == null ? 43 : ((Object)$latestBuild).hashCode());
        String $latestBuildUsername = this.getLatestBuildUsername();
        result = result * 59 + ($latestBuildUsername == null ? 43 : $latestBuildUsername.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BuildConfigurationWithLatestBuild(super=" + super.toString() + ", latestBuild=" + this.getLatestBuild() + ", latestBuildUsername=" + this.getLatestBuildUsername() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private SCMRepository scmRepository;
        private ProjectRef project;
        private Environment environment;
        private Map<String, BuildConfigurationRef> dependencies;
        private ProductVersionRef productVersion;
        private Map<String, GroupConfigurationRef> groupConfigs;
        private Map<String, String> parameters;
        private String id;
        private String name;
        private String description;
        private String buildScript;
        private String scmRevision;
        private Instant creationTime;
        private Instant modificationTime;
        private BuildType buildType;
        private User creationUser;
        private User modificationUser;
        private String defaultAlignmentParams;
        private Boolean brewPullActive;
        private Set<AlignmentStrategy> alignmentStrategies;
        private BuildRef latestBuild;
        private String latestBuildUsername;

        public Builder buildConfig(BuildConfiguration buildConfiguration) {
            this.id = buildConfiguration.id;
            this.name = buildConfiguration.name;
            this.description = buildConfiguration.description;
            this.buildScript = buildConfiguration.buildScript;
            this.scmRevision = buildConfiguration.scmRevision;
            this.creationTime = buildConfiguration.creationTime;
            this.modificationTime = buildConfiguration.modificationTime;
            this.buildType = buildConfiguration.buildType;
            this.defaultAlignmentParams = buildConfiguration.defaultAlignmentParams;
            this.brewPullActive = buildConfiguration.brewPullActive;
            this.scmRepository = buildConfiguration.scmRepository;
            this.project = buildConfiguration.project;
            this.environment = buildConfiguration.environment;
            this.dependencies = buildConfiguration.dependencies;
            this.productVersion = buildConfiguration.productVersion;
            this.groupConfigs = buildConfiguration.groupConfigs;
            this.parameters = buildConfiguration.parameters;
            this.creationUser = buildConfiguration.creationUser;
            this.modificationUser = buildConfiguration.modificationUser;
            this.alignmentStrategies = buildConfiguration.alignmentStrategies;
            return this;
        }

        Builder() {
        }

        public Builder scmRepository(SCMRepository scmRepository) {
            this.scmRepository = scmRepository;
            return this;
        }

        public Builder project(ProjectRef project) {
            this.project = project;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder dependencies(Map<String, BuildConfigurationRef> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public Builder groupConfigs(Map<String, GroupConfigurationRef> groupConfigs) {
            this.groupConfigs = groupConfigs;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder buildScript(String buildScript) {
            this.buildScript = buildScript;
            return this;
        }

        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        public Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public Builder creationUser(User creationUser) {
            this.creationUser = creationUser;
            return this;
        }

        public Builder modificationUser(User modificationUser) {
            this.modificationUser = modificationUser;
            return this;
        }

        public Builder defaultAlignmentParams(String defaultAlignmentParams) {
            this.defaultAlignmentParams = defaultAlignmentParams;
            return this;
        }

        public Builder brewPullActive(Boolean brewPullActive) {
            this.brewPullActive = brewPullActive;
            return this;
        }

        public Builder alignmentStrategies(Set<AlignmentStrategy> alignmentStrategies) {
            this.alignmentStrategies = alignmentStrategies;
            return this;
        }

        public Builder latestBuild(BuildRef latestBuild) {
            this.latestBuild = latestBuild;
            return this;
        }

        public Builder latestBuildUsername(String latestBuildUsername) {
            this.latestBuildUsername = latestBuildUsername;
            return this;
        }

        public BuildConfigurationWithLatestBuild build() {
            return new BuildConfigurationWithLatestBuild(this.scmRepository, this.project, this.environment, this.dependencies, this.productVersion, this.groupConfigs, this.parameters, this.id, this.name, this.description, this.buildScript, this.scmRevision, this.creationTime, this.modificationTime, this.buildType, this.creationUser, this.modificationUser, this.defaultAlignmentParams, this.brewPullActive, this.alignmentStrategies, this.latestBuild, this.latestBuildUsername);
        }

        public String toString() {
            return "BuildConfigurationWithLatestBuild.Builder(scmRepository=" + this.scmRepository + ", project=" + this.project + ", environment=" + this.environment + ", dependencies=" + this.dependencies + ", productVersion=" + this.productVersion + ", groupConfigs=" + this.groupConfigs + ", parameters=" + this.parameters + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", buildScript=" + this.buildScript + ", scmRevision=" + this.scmRevision + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", buildType=" + this.buildType + ", creationUser=" + this.creationUser + ", modificationUser=" + this.modificationUser + ", defaultAlignmentParams=" + this.defaultAlignmentParams + ", brewPullActive=" + this.brewPullActive + ", alignmentStrategies=" + this.alignmentStrategies + ", latestBuild=" + this.latestBuild + ", latestBuildUsername=" + this.latestBuildUsername + ")";
        }
    }
}

