/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Pattern;
import org.jboss.pnc.common.validator.NoHtml;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductRef
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String id;
    @NotBlank(groups={WhenCreatingNew.class, WhenUpdating.class})
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String name;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String description;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    @Pattern(regexp="[a-zA-Z0-9-]+", groups={WhenCreatingNew.class, WhenUpdating.class})
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class}) @Pattern(regexp="[a-zA-Z0-9-]+", groups={WhenCreatingNew.class, WhenUpdating.class}) String abbreviation;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String productManagers;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String productPagesCode;

    ProductRef(String id, String name, String description, String abbreviation, String productManagers, String productPagesCode) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.abbreviation = abbreviation;
        this.productManagers = productManagers;
        this.productPagesCode = productPagesCode;
    }

    public static Builder refBuilder() {
        return new Builder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getProductManagers() {
        return this.productManagers;
    }

    public String getProductPagesCode() {
        return this.productPagesCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductRef)) {
            return false;
        }
        ProductRef other = (ProductRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$abbreviation = this.getAbbreviation();
        String other$abbreviation = other.getAbbreviation();
        if (this$abbreviation == null ? other$abbreviation != null : !this$abbreviation.equals(other$abbreviation)) {
            return false;
        }
        String this$productManagers = this.getProductManagers();
        String other$productManagers = other.getProductManagers();
        if (this$productManagers == null ? other$productManagers != null : !this$productManagers.equals(other$productManagers)) {
            return false;
        }
        String this$productPagesCode = this.getProductPagesCode();
        String other$productPagesCode = other.getProductPagesCode();
        return !(this$productPagesCode == null ? other$productPagesCode != null : !this$productPagesCode.equals(other$productPagesCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductRef;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $abbreviation = this.getAbbreviation();
        result = result * 59 + ($abbreviation == null ? 43 : $abbreviation.hashCode());
        String $productManagers = this.getProductManagers();
        result = result * 59 + ($productManagers == null ? 43 : $productManagers.hashCode());
        String $productPagesCode = this.getProductPagesCode();
        result = result * 59 + ($productPagesCode == null ? 43 : $productPagesCode.hashCode());
        return result;
    }

    public String toString() {
        return "ProductRef(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", abbreviation=" + this.getAbbreviation() + ", productManagers=" + this.getProductManagers() + ", productPagesCode=" + this.getProductPagesCode() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private String abbreviation;
        private String productManagers;
        private String productPagesCode;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public Builder productManagers(String productManagers) {
            this.productManagers = productManagers;
            return this;
        }

        public Builder productPagesCode(String productPagesCode) {
            this.productPagesCode = productPagesCode;
            return this;
        }

        public ProductRef build() {
            return new ProductRef(this.id, this.name, this.description, this.abbreviation, this.productManagers, this.productPagesCode);
        }

        public String toString() {
            return "ProductRef.Builder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", abbreviation=" + this.abbreviation + ", productManagers=" + this.productManagers + ", productPagesCode=" + this.productPagesCode + ")";
        }
    }
}

