/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.requests;

import java.util.Arrays;
import org.jboss.pnc.api.dto.validation.ValidationResult;
import org.jboss.pnc.api.enums.Qualifier;

public class QValue {
    private final Qualifier qualifier;
    private final String[] value;

    public static QValue valueOf(String input) {
        if (!input.contains(":")) {
            throw new IllegalArgumentException("QValue " + input + " does not have ':' separator.");
        }
        Object[] split = input.split(":", 2);
        System.out.println(Arrays.toString(split));
        Qualifier qualifier = Qualifier.valueOf((String)((String)split[0]).trim().replace('-', '_'));
        if (((String)split[1]).trim().isEmpty()) {
            throw new IllegalArgumentException("Qualifier " + qualifier + " does not have value.");
        }
        String[] parts = ((String)split[1]).split(" ");
        ValidationResult result = qualifier.validate(parts);
        if (!result.valid) {
            throw new IllegalArgumentException("Validation for Qualifier " + qualifier + " failed: " + result.validationError);
        }
        return new QValue(qualifier, parts);
    }

    public String toString() {
        return this.qualifier.name() + ":" + String.join((CharSequence)" ", this.value);
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public String[] getValue() {
        return this.value;
    }

    public QValue(Qualifier qualifier, String[] value) {
        this.qualifier = qualifier;
        this.value = value;
    }
}

