/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.validation.validators;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.validator.routines.UrlValidator;
import org.jboss.pnc.dto.validation.constraints.SCMUrl;

public class SCMUrlValidator
implements ConstraintValidator<SCMUrl, String> {
    private static final char USERNAME_INDICATOR = '@';
    private static final Pattern USERNAME_PATTERN = Pattern.compile("[\\.\\-_%\\w]+", 256);
    private static final UrlValidator validator = new UrlValidator(new String[]{"http", "https", "git", "ssh", "git+ssh"});

    public void initialize(SCMUrl constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        return SCMUrlValidator.isValid(value);
    }

    public static boolean isValid(String url) {
        String username;
        if (url == null || "".equals(url)) {
            return true;
        }
        if (SCMUrlValidator.hasNoProtocol(url)) {
            url = SCMUrlValidator.prepareDefaultProtocolUrl(url);
        }
        if ((username = SCMUrlValidator.getUsername(url)) != null) {
            if (!SCMUrlValidator.isValidUsername(username)) {
                return false;
            }
            url = url.replaceFirst(username, "");
        }
        return validator.isValid(url);
    }

    private static String prepareDefaultProtocolUrl(String url) {
        url = ((String)url).replaceFirst(":", "/");
        url = "ssh://" + (String)url;
        return url;
    }

    private static boolean hasNoProtocol(String url) {
        return !url.contains("://");
    }

    private static boolean isValidUsername(String username) {
        username = username.replaceFirst("@", "");
        String[] usernameParts = username.split(":");
        return Stream.of(usernameParts).allMatch(p -> USERNAME_PATTERN.matcher((CharSequence)p).matches());
    }

    private static String getUsername(String url) {
        int atIndex = url.lastIndexOf(64);
        if (atIndex < 0) {
            return null;
        }
        String username = url.substring(0, atIndex + 1);
        int slashIndex = username.lastIndexOf(47);
        if (slashIndex > 0) {
            username = username.substring(slashIndex + 1);
        }
        return username;
    }
}

