package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.Object;
import java.lang.String;
import java.util.Collection;
import java.util.Map;
import org.jboss.pnc.dto.Operation;

public class OperationPatchBuilder extends PatchBase<OperationPatchBuilder, Operation> {
  public OperationPatchBuilder() {
    super(org.jboss.pnc.dto.Operation.class);
  }

  public OperationPatchBuilder addParameters(Map<String, String> elements) throws
      PatchBuilderException {
    try {
      return add(elements, "parameters");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public OperationPatchBuilder removeParameters(Collection<Object> keys) throws
      PatchBuilderException {
    try {
      return remove(keys, "parameters");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public OperationPatchBuilder replaceParameters(Map<String, String> element) throws
      PatchBuilderException {
    try {
      return replace(element, "parameters");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
