/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.Map;
import org.jboss.pnc.common.validator.NoHtml;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.SystemImageType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Environment
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String id;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String name;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String description;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String systemImageRepositoryUrl;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String systemImageId;
    private final Map<String, String> attributes;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final SystemImageType systemImageType;
    private final boolean deprecated;
    private final boolean hidden;

    Environment(String id, String name, String description, String systemImageRepositoryUrl, String systemImageId, Map<String, String> attributes, SystemImageType systemImageType, boolean deprecated, boolean hidden) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.systemImageRepositoryUrl = systemImageRepositoryUrl;
        this.systemImageId = systemImageId;
        this.attributes = attributes;
        this.systemImageType = systemImageType;
        this.deprecated = deprecated;
        this.hidden = hidden;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).name(this.name).description(this.description).systemImageRepositoryUrl(this.systemImageRepositoryUrl).systemImageId(this.systemImageId).attributes(this.attributes).systemImageType(this.systemImageType).deprecated(this.deprecated).hidden(this.hidden);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSystemImageRepositoryUrl() {
        return this.systemImageRepositoryUrl;
    }

    public String getSystemImageId() {
        return this.systemImageId;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public SystemImageType getSystemImageType() {
        return this.systemImageType;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeprecated() != other.isDeprecated()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$systemImageRepositoryUrl = this.getSystemImageRepositoryUrl();
        String other$systemImageRepositoryUrl = other.getSystemImageRepositoryUrl();
        if (this$systemImageRepositoryUrl == null ? other$systemImageRepositoryUrl != null : !this$systemImageRepositoryUrl.equals(other$systemImageRepositoryUrl)) {
            return false;
        }
        String this$systemImageId = this.getSystemImageId();
        String other$systemImageId = other.getSystemImageId();
        if (this$systemImageId == null ? other$systemImageId != null : !this$systemImageId.equals(other$systemImageId)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        SystemImageType this$systemImageType = this.getSystemImageType();
        SystemImageType other$systemImageType = other.getSystemImageType();
        return !(this$systemImageType == null ? other$systemImageType != null : !this$systemImageType.equals(other$systemImageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeprecated() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $systemImageRepositoryUrl = this.getSystemImageRepositoryUrl();
        result = result * 59 + ($systemImageRepositoryUrl == null ? 43 : $systemImageRepositoryUrl.hashCode());
        String $systemImageId = this.getSystemImageId();
        result = result * 59 + ($systemImageId == null ? 43 : $systemImageId.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        SystemImageType $systemImageType = this.getSystemImageType();
        result = result * 59 + ($systemImageType == null ? 43 : $systemImageType.hashCode());
        return result;
    }

    public String toString() {
        return "Environment(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", systemImageRepositoryUrl=" + this.getSystemImageRepositoryUrl() + ", systemImageId=" + this.getSystemImageId() + ", attributes=" + this.getAttributes() + ", systemImageType=" + this.getSystemImageType() + ", deprecated=" + this.isDeprecated() + ", hidden=" + this.isHidden() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private String systemImageRepositoryUrl;
        private String systemImageId;
        private Map<String, String> attributes;
        private SystemImageType systemImageType;
        private boolean deprecated;
        private boolean hidden;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder systemImageRepositoryUrl(String systemImageRepositoryUrl) {
            this.systemImageRepositoryUrl = systemImageRepositoryUrl;
            return this;
        }

        public Builder systemImageId(String systemImageId) {
            this.systemImageId = systemImageId;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder systemImageType(SystemImageType systemImageType) {
            this.systemImageType = systemImageType;
            return this;
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Environment build() {
            return new Environment(this.id, this.name, this.description, this.systemImageRepositoryUrl, this.systemImageId, this.attributes, this.systemImageType, this.deprecated, this.hidden);
        }

        public String toString() {
            return "Environment.Builder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", systemImageRepositoryUrl=" + this.systemImageRepositoryUrl + ", systemImageId=" + this.systemImageId + ", attributes=" + this.attributes + ", systemImageType=" + this.systemImageType + ", deprecated=" + this.deprecated + ", hidden=" + this.hidden + ")";
        }
    }
}

