/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.response;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=Builder.class)
public class Edge<T> {
    private final String source;
    private final String target;
    private final int cost;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public int getCost() {
        return this.cost;
    }

    public Edge(String source, String target, int cost) {
        this.source = source;
        this.target = target;
        this.cost = cost;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder<T> {
        private String source;
        private String target;
        private int cost;

        Builder() {
        }

        public Builder<T> source(String source) {
            this.source = source;
            return this;
        }

        public Builder<T> target(String target) {
            this.target = target;
            return this;
        }

        public Builder<T> cost(int cost) {
            this.cost = cost;
            return this;
        }

        public Edge<T> build() {
            return new Edge(this.source, this.target, this.cost);
        }

        public String toString() {
            return "Edge.Builder(source=" + this.source + ", target=" + this.target + ", cost=" + this.cost + ")";
        }
    }
}

