/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.response.statistics;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public final class ProductVersionDeliveredArtifactsStatistics {
    private final long thisVersion;
    private final long otherVersions;
    private final long otherProducts;
    private final long noMilestone;
    private final long noBuild;

    ProductVersionDeliveredArtifactsStatistics(long thisVersion, long otherVersions, long otherProducts, long noMilestone, long noBuild) {
        this.thisVersion = thisVersion;
        this.otherVersions = otherVersions;
        this.otherProducts = otherProducts;
        this.noMilestone = noMilestone;
        this.noBuild = noBuild;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getThisVersion() {
        return this.thisVersion;
    }

    public long getOtherVersions() {
        return this.otherVersions;
    }

    public long getOtherProducts() {
        return this.otherProducts;
    }

    public long getNoMilestone() {
        return this.noMilestone;
    }

    public long getNoBuild() {
        return this.noBuild;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductVersionDeliveredArtifactsStatistics)) {
            return false;
        }
        ProductVersionDeliveredArtifactsStatistics other = (ProductVersionDeliveredArtifactsStatistics)o;
        if (this.getThisVersion() != other.getThisVersion()) {
            return false;
        }
        if (this.getOtherVersions() != other.getOtherVersions()) {
            return false;
        }
        if (this.getOtherProducts() != other.getOtherProducts()) {
            return false;
        }
        if (this.getNoMilestone() != other.getNoMilestone()) {
            return false;
        }
        return this.getNoBuild() == other.getNoBuild();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $thisVersion = this.getThisVersion();
        result = result * 59 + (int)($thisVersion >>> 32 ^ $thisVersion);
        long $otherVersions = this.getOtherVersions();
        result = result * 59 + (int)($otherVersions >>> 32 ^ $otherVersions);
        long $otherProducts = this.getOtherProducts();
        result = result * 59 + (int)($otherProducts >>> 32 ^ $otherProducts);
        long $noMilestone = this.getNoMilestone();
        result = result * 59 + (int)($noMilestone >>> 32 ^ $noMilestone);
        long $noBuild = this.getNoBuild();
        result = result * 59 + (int)($noBuild >>> 32 ^ $noBuild);
        return result;
    }

    public String toString() {
        return "ProductVersionDeliveredArtifactsStatistics(thisVersion=" + this.getThisVersion() + ", otherVersions=" + this.getOtherVersions() + ", otherProducts=" + this.getOtherProducts() + ", noMilestone=" + this.getNoMilestone() + ", noBuild=" + this.getNoBuild() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private long thisVersion;
        private long otherVersions;
        private long otherProducts;
        private long noMilestone;
        private long noBuild;

        Builder() {
        }

        public Builder thisVersion(long thisVersion) {
            this.thisVersion = thisVersion;
            return this;
        }

        public Builder otherVersions(long otherVersions) {
            this.otherVersions = otherVersions;
            return this;
        }

        public Builder otherProducts(long otherProducts) {
            this.otherProducts = otherProducts;
            return this;
        }

        public Builder noMilestone(long noMilestone) {
            this.noMilestone = noMilestone;
            return this;
        }

        public Builder noBuild(long noBuild) {
            this.noBuild = noBuild;
            return this;
        }

        public ProductVersionDeliveredArtifactsStatistics build() {
            return new ProductVersionDeliveredArtifactsStatistics(this.thisVersion, this.otherVersions, this.otherProducts, this.noMilestone, this.noBuild);
        }

        public String toString() {
            return "ProductVersionDeliveredArtifactsStatistics.Builder(thisVersion=" + this.thisVersion + ", otherVersions=" + this.otherVersions + ", otherProducts=" + this.otherProducts + ", noMilestone=" + this.noMilestone + ", noBuild=" + this.noBuild + ")";
        }
    }
}

