/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Map;
import org.jboss.pnc.dto.BuildConfigurationRevisionRef;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.enums.BuildType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildConfigurationRevision
extends BuildConfigurationRevisionRef {
    private final SCMRepository scmRepository;
    private final ProjectRef project;
    private final Environment environment;
    private final Map<String, String> parameters;
    private final User creationUser;
    private final User modificationUser;

    private BuildConfigurationRevision(SCMRepository scmRepository, ProjectRef project, Environment environment, Map<String, String> parameters, String id, Integer rev, String name, String buildScript, String scmRevision, Instant creationTime, Instant modificationTime, BuildType buildType, User creationUser, User modificationUser, String defaultAlignmentParams, boolean brewPullActive) {
        super(id, rev, name, buildScript, scmRevision, creationTime, modificationTime, buildType, defaultAlignmentParams, brewPullActive);
        this.scmRepository = scmRepository;
        this.project = project;
        this.environment = environment;
        this.parameters = parameters;
        this.creationUser = creationUser;
        this.modificationUser = modificationUser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().scmRepository(this.scmRepository).project(this.project).environment(this.environment).parameters(this.parameters).id(this.id).rev(this.rev).name(this.name).buildScript(this.buildScript).scmRevision(this.scmRevision).creationTime(this.creationTime).modificationTime(this.modificationTime).buildType(this.buildType).creationUser(this.creationUser).modificationUser(this.modificationUser).defaultAlignmentParams(this.defaultAlignmentParams).brewPullActive(this.brewPullActive);
    }

    public SCMRepository getScmRepository() {
        return this.scmRepository;
    }

    public ProjectRef getProject() {
        return this.project;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public User getCreationUser() {
        return this.creationUser;
    }

    public User getModificationUser() {
        return this.modificationUser;
    }

    @Override
    public String toString() {
        return "BuildConfigurationRevision(super=" + super.toString() + ", scmRepository=" + this.getScmRepository() + ", project=" + this.getProject() + ", environment=" + this.getEnvironment() + ", parameters=" + this.getParameters() + ", creationUser=" + this.getCreationUser() + ", modificationUser=" + this.getModificationUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfigurationRevision)) {
            return false;
        }
        BuildConfigurationRevision other = (BuildConfigurationRevision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SCMRepository this$scmRepository = this.getScmRepository();
        SCMRepository other$scmRepository = other.getScmRepository();
        if (this$scmRepository == null ? other$scmRepository != null : !((Object)this$scmRepository).equals(other$scmRepository)) {
            return false;
        }
        ProjectRef this$project = this.getProject();
        ProjectRef other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        User this$creationUser = this.getCreationUser();
        User other$creationUser = other.getCreationUser();
        if (this$creationUser == null ? other$creationUser != null : !((Object)this$creationUser).equals(other$creationUser)) {
            return false;
        }
        User this$modificationUser = this.getModificationUser();
        User other$modificationUser = other.getModificationUser();
        return !(this$modificationUser == null ? other$modificationUser != null : !((Object)this$modificationUser).equals(other$modificationUser));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BuildConfigurationRevision;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SCMRepository $scmRepository = this.getScmRepository();
        result = result * 59 + ($scmRepository == null ? 43 : ((Object)$scmRepository).hashCode());
        ProjectRef $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        User $creationUser = this.getCreationUser();
        result = result * 59 + ($creationUser == null ? 43 : ((Object)$creationUser).hashCode());
        User $modificationUser = this.getModificationUser();
        result = result * 59 + ($modificationUser == null ? 43 : ((Object)$modificationUser).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private SCMRepository scmRepository;
        private ProjectRef project;
        private Environment environment;
        private Map<String, String> parameters;
        private String id;
        private Integer rev;
        private String name;
        private String buildScript;
        private String scmRevision;
        private Instant creationTime;
        private Instant modificationTime;
        private BuildType buildType;
        private User creationUser;
        private User modificationUser;
        private String defaultAlignmentParams;
        private boolean brewPullActive;

        Builder() {
        }

        public Builder scmRepository(SCMRepository scmRepository) {
            this.scmRepository = scmRepository;
            return this;
        }

        public Builder project(ProjectRef project) {
            this.project = project;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder rev(Integer rev) {
            this.rev = rev;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder buildScript(String buildScript) {
            this.buildScript = buildScript;
            return this;
        }

        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        public Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public Builder creationUser(User creationUser) {
            this.creationUser = creationUser;
            return this;
        }

        public Builder modificationUser(User modificationUser) {
            this.modificationUser = modificationUser;
            return this;
        }

        public Builder defaultAlignmentParams(String defaultAlignmentParams) {
            this.defaultAlignmentParams = defaultAlignmentParams;
            return this;
        }

        public Builder brewPullActive(boolean brewPullActive) {
            this.brewPullActive = brewPullActive;
            return this;
        }

        public BuildConfigurationRevision build() {
            return new BuildConfigurationRevision(this.scmRepository, this.project, this.environment, this.parameters, this.id, this.rev, this.name, this.buildScript, this.scmRevision, this.creationTime, this.modificationTime, this.buildType, this.creationUser, this.modificationUser, this.defaultAlignmentParams, this.brewPullActive);
        }

        public String toString() {
            return "BuildConfigurationRevision.Builder(scmRepository=" + this.scmRepository + ", project=" + this.project + ", environment=" + this.environment + ", parameters=" + this.parameters + ", id=" + this.id + ", rev=" + this.rev + ", name=" + this.name + ", buildScript=" + this.buildScript + ", scmRevision=" + this.scmRevision + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", buildType=" + this.buildType + ", creationUser=" + this.creationUser + ", modificationUser=" + this.modificationUser + ", defaultAlignmentParams=" + this.defaultAlignmentParams + ", brewPullActive=" + this.brewPullActive + ")";
        }
    }
}

