/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.time.Instant;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.common.validator.NoHtml;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildProgress;
import org.jboss.pnc.enums.BuildStatus;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildRef
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String id;
    protected final Instant submitTime;
    protected final Instant startTime;
    protected final Instant endTime;
    protected final BuildProgress progress;
    protected final BuildStatus status;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String buildContentId;
    protected final Boolean temporaryBuild;
    protected final AlignmentPreference alignmentPreference;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String scmUrl;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String scmRevision;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String scmTag;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String buildOutputChecksum;
    protected final Instant lastUpdateTime;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String scmBuildConfigRevision;
    protected final Boolean scmBuildConfigRevisionInternal;

    BuildRef(String id, Instant submitTime, Instant startTime, Instant endTime, BuildProgress progress, BuildStatus status, String buildContentId, Boolean temporaryBuild, AlignmentPreference alignmentPreference, String scmUrl, String scmRevision, String scmTag, String buildOutputChecksum, Instant lastUpdateTime, String scmBuildConfigRevision, Boolean scmBuildConfigRevisionInternal) {
        this.id = id;
        this.submitTime = submitTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.progress = progress;
        this.status = status;
        this.buildContentId = buildContentId;
        this.temporaryBuild = temporaryBuild;
        this.alignmentPreference = alignmentPreference;
        this.scmUrl = scmUrl;
        this.scmRevision = scmRevision;
        this.scmTag = scmTag;
        this.buildOutputChecksum = buildOutputChecksum;
        this.lastUpdateTime = lastUpdateTime;
        this.scmBuildConfigRevision = scmBuildConfigRevision;
        this.scmBuildConfigRevisionInternal = scmBuildConfigRevisionInternal;
    }

    public static Builder refBuilder() {
        return new Builder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Instant getSubmitTime() {
        return this.submitTime;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public BuildProgress getProgress() {
        return this.progress;
    }

    public BuildStatus getStatus() {
        return this.status;
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public Boolean getTemporaryBuild() {
        return this.temporaryBuild;
    }

    public AlignmentPreference getAlignmentPreference() {
        return this.alignmentPreference;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public String getBuildOutputChecksum() {
        return this.buildOutputChecksum;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getScmBuildConfigRevision() {
        return this.scmBuildConfigRevision;
    }

    public Boolean getScmBuildConfigRevisionInternal() {
        return this.scmBuildConfigRevisionInternal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildRef)) {
            return false;
        }
        BuildRef other = (BuildRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$temporaryBuild = this.getTemporaryBuild();
        Boolean other$temporaryBuild = other.getTemporaryBuild();
        if (this$temporaryBuild == null ? other$temporaryBuild != null : !((Object)this$temporaryBuild).equals(other$temporaryBuild)) {
            return false;
        }
        Boolean this$scmBuildConfigRevisionInternal = this.getScmBuildConfigRevisionInternal();
        Boolean other$scmBuildConfigRevisionInternal = other.getScmBuildConfigRevisionInternal();
        if (this$scmBuildConfigRevisionInternal == null ? other$scmBuildConfigRevisionInternal != null : !((Object)this$scmBuildConfigRevisionInternal).equals(other$scmBuildConfigRevisionInternal)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Instant this$submitTime = this.getSubmitTime();
        Instant other$submitTime = other.getSubmitTime();
        if (this$submitTime == null ? other$submitTime != null : !((Object)this$submitTime).equals(other$submitTime)) {
            return false;
        }
        Instant this$startTime = this.getStartTime();
        Instant other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Instant this$endTime = this.getEndTime();
        Instant other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        BuildProgress this$progress = this.getProgress();
        BuildProgress other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !this$progress.equals(other$progress)) {
            return false;
        }
        BuildStatus this$status = this.getStatus();
        BuildStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$buildContentId = this.getBuildContentId();
        String other$buildContentId = other.getBuildContentId();
        if (this$buildContentId == null ? other$buildContentId != null : !this$buildContentId.equals(other$buildContentId)) {
            return false;
        }
        AlignmentPreference this$alignmentPreference = this.getAlignmentPreference();
        AlignmentPreference other$alignmentPreference = other.getAlignmentPreference();
        if (this$alignmentPreference == null ? other$alignmentPreference != null : !this$alignmentPreference.equals(other$alignmentPreference)) {
            return false;
        }
        String this$scmUrl = this.getScmUrl();
        String other$scmUrl = other.getScmUrl();
        if (this$scmUrl == null ? other$scmUrl != null : !this$scmUrl.equals(other$scmUrl)) {
            return false;
        }
        String this$scmRevision = this.getScmRevision();
        String other$scmRevision = other.getScmRevision();
        if (this$scmRevision == null ? other$scmRevision != null : !this$scmRevision.equals(other$scmRevision)) {
            return false;
        }
        String this$scmTag = this.getScmTag();
        String other$scmTag = other.getScmTag();
        if (this$scmTag == null ? other$scmTag != null : !this$scmTag.equals(other$scmTag)) {
            return false;
        }
        String this$buildOutputChecksum = this.getBuildOutputChecksum();
        String other$buildOutputChecksum = other.getBuildOutputChecksum();
        if (this$buildOutputChecksum == null ? other$buildOutputChecksum != null : !this$buildOutputChecksum.equals(other$buildOutputChecksum)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$scmBuildConfigRevision = this.getScmBuildConfigRevision();
        String other$scmBuildConfigRevision = other.getScmBuildConfigRevision();
        return !(this$scmBuildConfigRevision == null ? other$scmBuildConfigRevision != null : !this$scmBuildConfigRevision.equals(other$scmBuildConfigRevision));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildRef;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $temporaryBuild = this.getTemporaryBuild();
        result = result * 59 + ($temporaryBuild == null ? 43 : ((Object)$temporaryBuild).hashCode());
        Boolean $scmBuildConfigRevisionInternal = this.getScmBuildConfigRevisionInternal();
        result = result * 59 + ($scmBuildConfigRevisionInternal == null ? 43 : ((Object)$scmBuildConfigRevisionInternal).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Instant $submitTime = this.getSubmitTime();
        result = result * 59 + ($submitTime == null ? 43 : ((Object)$submitTime).hashCode());
        Instant $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Instant $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        BuildProgress $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        BuildStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $buildContentId = this.getBuildContentId();
        result = result * 59 + ($buildContentId == null ? 43 : $buildContentId.hashCode());
        AlignmentPreference $alignmentPreference = this.getAlignmentPreference();
        result = result * 59 + ($alignmentPreference == null ? 43 : $alignmentPreference.hashCode());
        String $scmUrl = this.getScmUrl();
        result = result * 59 + ($scmUrl == null ? 43 : $scmUrl.hashCode());
        String $scmRevision = this.getScmRevision();
        result = result * 59 + ($scmRevision == null ? 43 : $scmRevision.hashCode());
        String $scmTag = this.getScmTag();
        result = result * 59 + ($scmTag == null ? 43 : $scmTag.hashCode());
        String $buildOutputChecksum = this.getBuildOutputChecksum();
        result = result * 59 + ($buildOutputChecksum == null ? 43 : $buildOutputChecksum.hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $scmBuildConfigRevision = this.getScmBuildConfigRevision();
        result = result * 59 + ($scmBuildConfigRevision == null ? 43 : $scmBuildConfigRevision.hashCode());
        return result;
    }

    public String toString() {
        return "BuildRef(id=" + this.getId() + ", submitTime=" + this.getSubmitTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", progress=" + this.getProgress() + ", status=" + this.getStatus() + ", buildContentId=" + this.getBuildContentId() + ", temporaryBuild=" + this.getTemporaryBuild() + ", alignmentPreference=" + this.getAlignmentPreference() + ", scmUrl=" + this.getScmUrl() + ", scmRevision=" + this.getScmRevision() + ", scmTag=" + this.getScmTag() + ", buildOutputChecksum=" + this.getBuildOutputChecksum() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", scmBuildConfigRevision=" + this.getScmBuildConfigRevision() + ", scmBuildConfigRevisionInternal=" + this.getScmBuildConfigRevisionInternal() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private Instant submitTime;
        private Instant startTime;
        private Instant endTime;
        private BuildProgress progress;
        private BuildStatus status;
        private String buildContentId;
        private Boolean temporaryBuild;
        private AlignmentPreference alignmentPreference;
        private String scmUrl;
        private String scmRevision;
        private String scmTag;
        private String buildOutputChecksum;
        private Instant lastUpdateTime;
        private String scmBuildConfigRevision;
        private Boolean scmBuildConfigRevisionInternal;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder progress(BuildProgress progress) {
            this.progress = progress;
            return this;
        }

        public Builder status(BuildStatus status) {
            this.status = status;
            return this;
        }

        public Builder buildContentId(String buildContentId) {
            this.buildContentId = buildContentId;
            return this;
        }

        public Builder temporaryBuild(Boolean temporaryBuild) {
            this.temporaryBuild = temporaryBuild;
            return this;
        }

        public Builder alignmentPreference(AlignmentPreference alignmentPreference) {
            this.alignmentPreference = alignmentPreference;
            return this;
        }

        public Builder scmUrl(String scmUrl) {
            this.scmUrl = scmUrl;
            return this;
        }

        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        public Builder scmTag(String scmTag) {
            this.scmTag = scmTag;
            return this;
        }

        public Builder buildOutputChecksum(String buildOutputChecksum) {
            this.buildOutputChecksum = buildOutputChecksum;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Builder scmBuildConfigRevision(String scmBuildConfigRevision) {
            this.scmBuildConfigRevision = scmBuildConfigRevision;
            return this;
        }

        public Builder scmBuildConfigRevisionInternal(Boolean scmBuildConfigRevisionInternal) {
            this.scmBuildConfigRevisionInternal = scmBuildConfigRevisionInternal;
            return this;
        }

        public BuildRef build() {
            return new BuildRef(this.id, this.submitTime, this.startTime, this.endTime, this.progress, this.status, this.buildContentId, this.temporaryBuild, this.alignmentPreference, this.scmUrl, this.scmRevision, this.scmTag, this.buildOutputChecksum, this.lastUpdateTime, this.scmBuildConfigRevision, this.scmBuildConfigRevisionInternal);
        }

        public String toString() {
            return "BuildRef.Builder(id=" + this.id + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", progress=" + this.progress + ", status=" + this.status + ", buildContentId=" + this.buildContentId + ", temporaryBuild=" + this.temporaryBuild + ", alignmentPreference=" + this.alignmentPreference + ", scmUrl=" + this.scmUrl + ", scmRevision=" + this.scmRevision + ", scmTag=" + this.scmTag + ", buildOutputChecksum=" + this.buildOutputChecksum + ", lastUpdateTime=" + this.lastUpdateTime + ", scmBuildConfigRevision=" + this.scmBuildConfigRevision + ", scmBuildConfigRevisionInternal=" + this.scmBuildConfigRevisionInternal + ")";
        }
    }
}

