/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.response;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=Builder.class)
public class ErrorResponse {
    private final String errorType;
    private final String errorMessage;
    private final Object details;

    public ErrorResponse(String errorType, String errorMessage) {
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.details = null;
    }

    public ErrorResponse(Exception e) {
        this.errorType = e.getClass().getSimpleName();
        this.errorMessage = e.getMessage();
        this.details = null;
    }

    public ErrorResponse(Exception e, Object details) {
        this.errorType = e.getClass().getSimpleName();
        this.errorMessage = e.getMessage();
        this.details = details;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Object getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorType = this.getErrorType();
        String other$errorType = other.getErrorType();
        if (this$errorType == null ? other$errorType != null : !this$errorType.equals(other$errorType)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        Object this$details = this.getDetails();
        Object other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !this$details.equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorType = this.getErrorType();
        result = result * 59 + ($errorType == null ? 43 : $errorType.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        Object $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        return result;
    }

    public String toString() {
        return "ErrorResponse(errorType=" + this.getErrorType() + ", errorMessage=" + this.getErrorMessage() + ", details=" + this.getDetails() + ")";
    }

    public ErrorResponse(String errorType, String errorMessage, Object details) {
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.details = details;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String errorType;
        private String errorMessage;
        private Object details;

        Builder() {
        }

        public Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder details(Object details) {
            this.details = details;
            return this;
        }

        public ErrorResponse build() {
            return new ErrorResponse(this.errorType, this.errorMessage, this.details);
        }

        public String toString() {
            return "ErrorResponse.Builder(errorType=" + this.errorType + ", errorMessage=" + this.errorMessage + ", details=" + this.details + ")";
        }
    }
}

