/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.response;

import java.util.Collection;
import java.util.Collections;

public class Page<T> {
    private int pageIndex;
    private int pageSize;
    private int totalPages;
    private int totalHits;
    private Collection<T> content;

    public Page() {
        this.content = Collections.emptyList();
    }

    public Page(int pageIndex, int pageSize, int totalHits, Collection<T> content) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalPages = (int)Math.ceil((double)totalHits / (double)pageSize);
        this.totalHits = totalHits;
        this.content = content;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public Collection<T> getContent() {
        return this.content;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalHits(int totalHits) {
        this.totalHits = totalHits;
    }

    public void setContent(Collection<T> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getTotalHits() != other.getTotalHits()) {
            return false;
        }
        Collection<T> this$content = this.getContent();
        Collection<T> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageIndex();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getTotalHits();
        Collection<T> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "Page(pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", totalPages=" + this.getTotalPages() + ", totalHits=" + this.getTotalHits() + ", content=" + this.getContent() + ")";
    }

    public Page(int pageIndex, int pageSize, int totalPages, int totalHits, Collection<T> content) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalPages = totalPages;
        this.totalHits = totalHits;
        this.content = content;
    }
}

