/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.List;
import org.jboss.pnc.dto.BuildPushResultRef;
import org.jboss.pnc.dto.ProductMilestoneCloseResultRef;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.enums.MilestoneCloseStatus;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductMilestoneCloseResult
extends ProductMilestoneCloseResultRef {
    private final ProductMilestoneRef milestone;
    private final List<BuildPushResultRef> buildPushResults;

    private ProductMilestoneCloseResult(ProductMilestoneRef milestone, List<BuildPushResultRef> buildPushResults, String id, Instant startingDate, Instant endDate, MilestoneCloseStatus status) {
        super(id, status, startingDate, endDate);
        this.milestone = milestone;
        this.buildPushResults = buildPushResults;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().milestone(this.milestone).buildPushResults(this.buildPushResults).id(this.id).startingDate(this.startingDate).endDate(this.endDate).status(this.status);
    }

    public ProductMilestoneRef getMilestone() {
        return this.milestone;
    }

    public List<BuildPushResultRef> getBuildPushResults() {
        return this.buildPushResults;
    }

    @Override
    public String toString() {
        return "ProductMilestoneCloseResult(super=" + super.toString() + ", milestone=" + this.getMilestone() + ", buildPushResults=" + this.getBuildPushResults() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductMilestoneCloseResult)) {
            return false;
        }
        ProductMilestoneCloseResult other = (ProductMilestoneCloseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProductMilestoneRef this$milestone = this.getMilestone();
        ProductMilestoneRef other$milestone = other.getMilestone();
        if (this$milestone == null ? other$milestone != null : !((Object)this$milestone).equals(other$milestone)) {
            return false;
        }
        List<BuildPushResultRef> this$buildPushResults = this.getBuildPushResults();
        List<BuildPushResultRef> other$buildPushResults = other.getBuildPushResults();
        return !(this$buildPushResults == null ? other$buildPushResults != null : !((Object)this$buildPushResults).equals(other$buildPushResults));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProductMilestoneCloseResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProductMilestoneRef $milestone = this.getMilestone();
        result = result * 59 + ($milestone == null ? 43 : ((Object)$milestone).hashCode());
        List<BuildPushResultRef> $buildPushResults = this.getBuildPushResults();
        result = result * 59 + ($buildPushResults == null ? 43 : ((Object)$buildPushResults).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private ProductMilestoneRef milestone;
        private List<BuildPushResultRef> buildPushResults;
        private String id;
        private Instant startingDate;
        private Instant endDate;
        private MilestoneCloseStatus status;

        Builder() {
        }

        public Builder milestone(ProductMilestoneRef milestone) {
            this.milestone = milestone;
            return this;
        }

        public Builder buildPushResults(List<BuildPushResultRef> buildPushResults) {
            this.buildPushResults = buildPushResults;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder startingDate(Instant startingDate) {
            this.startingDate = startingDate;
            return this;
        }

        public Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder status(MilestoneCloseStatus status) {
            this.status = status;
            return this;
        }

        public ProductMilestoneCloseResult build() {
            return new ProductMilestoneCloseResult(this.milestone, this.buildPushResults, this.id, this.startingDate, this.endDate, this.status);
        }

        public String toString() {
            return "ProductMilestoneCloseResult.Builder(milestone=" + this.milestone + ", buildPushResults=" + this.buildPushResults + ", id=" + this.id + ", startingDate=" + this.startingDate + ", endDate=" + this.endDate + ", status=" + this.status + ")";
        }
    }
}

