/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import java.time.Instant;
import org.jboss.pnc.common.validator.NoHtml;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductMilestoneRef
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final String id;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    @Pattern(groups={WhenCreatingNew.class, WhenUpdating.class}, regexp="^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$", message="Version doesn't match the required pattern ^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$")
    protected final @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class}) @Pattern(groups={WhenCreatingNew.class, WhenUpdating.class}, regexp="^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$", message="Version doesn't match the required pattern ^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$") String version;
    @Null(groups={WhenCreatingNew.class})
    protected final Instant endDate;
    protected final Instant startingDate;
    protected final Instant plannedEndDate;

    ProductMilestoneRef(String id, String version, Instant endDate, Instant startingDate, Instant plannedEndDate) {
        this.id = id;
        this.version = version;
        this.endDate = endDate;
        this.startingDate = startingDate;
        this.plannedEndDate = plannedEndDate;
    }

    public static Builder refBuilder() {
        return new Builder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public Instant getStartingDate() {
        return this.startingDate;
    }

    public Instant getPlannedEndDate() {
        return this.plannedEndDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductMilestoneRef)) {
            return false;
        }
        ProductMilestoneRef other = (ProductMilestoneRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Instant this$endDate = this.getEndDate();
        Instant other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Instant this$startingDate = this.getStartingDate();
        Instant other$startingDate = other.getStartingDate();
        if (this$startingDate == null ? other$startingDate != null : !((Object)this$startingDate).equals(other$startingDate)) {
            return false;
        }
        Instant this$plannedEndDate = this.getPlannedEndDate();
        Instant other$plannedEndDate = other.getPlannedEndDate();
        return !(this$plannedEndDate == null ? other$plannedEndDate != null : !((Object)this$plannedEndDate).equals(other$plannedEndDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductMilestoneRef;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Instant $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Instant $startingDate = this.getStartingDate();
        result = result * 59 + ($startingDate == null ? 43 : ((Object)$startingDate).hashCode());
        Instant $plannedEndDate = this.getPlannedEndDate();
        result = result * 59 + ($plannedEndDate == null ? 43 : ((Object)$plannedEndDate).hashCode());
        return result;
    }

    public String toString() {
        return "ProductMilestoneRef(id=" + this.getId() + ", version=" + this.getVersion() + ", endDate=" + this.getEndDate() + ", startingDate=" + this.getStartingDate() + ", plannedEndDate=" + this.getPlannedEndDate() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private String version;
        private Instant endDate;
        private Instant startingDate;
        private Instant plannedEndDate;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder startingDate(Instant startingDate) {
            this.startingDate = startingDate;
            return this;
        }

        public Builder plannedEndDate(Instant plannedEndDate) {
            this.plannedEndDate = plannedEndDate;
            return this;
        }

        public ProductMilestoneRef build() {
            return new ProductMilestoneRef(this.id, this.version, this.endDate, this.startingDate, this.plannedEndDate);
        }

        public String toString() {
            return "ProductMilestoneRef.Builder(id=" + this.id + ", version=" + this.version + ", endDate=" + this.endDate + ", startingDate=" + this.startingDate + ", plannedEndDate=" + this.plannedEndDate + ")";
        }
    }
}

