/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.validation.constraints.RefHasId;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.SupportLevel;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductRelease
extends ProductReleaseRef {
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final ProductVersionRef productVersion;
    private final ProductMilestoneRef productMilestone;

    private ProductRelease(ProductVersionRef productVersion, ProductMilestoneRef productMilestone, String id, String version, SupportLevel supportLevel, Instant releaseDate, String commonPlatformEnumeration, String productPagesCode) {
        super(id, version, supportLevel, releaseDate, commonPlatformEnumeration, productPagesCode);
        this.productVersion = productVersion;
        this.productMilestone = productMilestone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().productVersion(this.productVersion).productMilestone(this.productMilestone).id(this.id).version(this.version).supportLevel(this.supportLevel).releaseDate(this.releaseDate).commonPlatformEnumeration(this.commonPlatformEnumeration).productPagesCode(this.productPagesCode);
    }

    public ProductVersionRef getProductVersion() {
        return this.productVersion;
    }

    public ProductMilestoneRef getProductMilestone() {
        return this.productMilestone;
    }

    @Override
    public String toString() {
        return "ProductRelease(super=" + super.toString() + ", productVersion=" + this.getProductVersion() + ", productMilestone=" + this.getProductMilestone() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductRelease)) {
            return false;
        }
        ProductRelease other = (ProductRelease)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProductVersionRef this$productVersion = this.getProductVersion();
        ProductVersionRef other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !((Object)this$productVersion).equals(other$productVersion)) {
            return false;
        }
        ProductMilestoneRef this$productMilestone = this.getProductMilestone();
        ProductMilestoneRef other$productMilestone = other.getProductMilestone();
        return !(this$productMilestone == null ? other$productMilestone != null : !((Object)this$productMilestone).equals(other$productMilestone));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProductRelease;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProductVersionRef $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : ((Object)$productVersion).hashCode());
        ProductMilestoneRef $productMilestone = this.getProductMilestone();
        result = result * 59 + ($productMilestone == null ? 43 : ((Object)$productMilestone).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private ProductVersionRef productVersion;
        private ProductMilestoneRef productMilestone;
        private String id;
        private String version;
        private SupportLevel supportLevel;
        private Instant releaseDate;
        private String commonPlatformEnumeration;
        private String productPagesCode;

        Builder() {
        }

        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public Builder productMilestone(ProductMilestoneRef productMilestone) {
            this.productMilestone = productMilestone;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder supportLevel(SupportLevel supportLevel) {
            this.supportLevel = supportLevel;
            return this;
        }

        public Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder commonPlatformEnumeration(String commonPlatformEnumeration) {
            this.commonPlatformEnumeration = commonPlatformEnumeration;
            return this;
        }

        public Builder productPagesCode(String productPagesCode) {
            this.productPagesCode = productPagesCode;
            return this;
        }

        public ProductRelease build() {
            return new ProductRelease(this.productVersion, this.productMilestone, this.id, this.version, this.supportLevel, this.releaseDate, this.commonPlatformEnumeration, this.productPagesCode);
        }

        public String toString() {
            return "ProductRelease.Builder(productVersion=" + this.productVersion + ", productMilestone=" + this.productMilestone + ", id=" + this.id + ", version=" + this.version + ", supportLevel=" + this.supportLevel + ", releaseDate=" + this.releaseDate + ", commonPlatformEnumeration=" + this.commonPlatformEnumeration + ", productPagesCode=" + this.productPagesCode + ")";
        }
    }
}

