package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.Object;
import java.lang.String;
import java.util.Collection;
import java.util.Map;
import org.jboss.pnc.dto.Build;

public class BuildPatchBuilder extends PatchBase<BuildPatchBuilder, Build> {
  public BuildPatchBuilder() {
    super(org.jboss.pnc.dto.Build.class);
  }

  public BuildPatchBuilder addAttributes(Map<String, String> elements) throws
      PatchBuilderException {
    try {
      return add(elements, "attributes");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public BuildPatchBuilder removeAttributes(Collection<Object> keys) throws PatchBuilderException {
    try {
      return remove(keys, "attributes");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public BuildPatchBuilder replaceAttributes(Map<String, String> element) throws
      PatchBuilderException {
    try {
      return replace(element, "attributes");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
