/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Map;
import lombok.Generated;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.validation.constraints.RefHasId;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupConfiguration
extends GroupConfigurationRef {
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class}, optional=true)
    private final ProductVersionRef productVersion;
    private final Map<String, BuildConfigurationRef> buildConfigs;

    GroupConfiguration(ProductVersionRef productVersion, Map<String, BuildConfigurationRef> buildConfigs, String id, String name) {
        super(id, name);
        this.productVersion = productVersion;
        this.buildConfigs = buildConfigs;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().productVersion(this.productVersion).buildConfigs(this.buildConfigs).id(this.id).name(this.name);
    }

    @Generated
    public ProductVersionRef getProductVersion() {
        return this.productVersion;
    }

    @Generated
    public Map<String, BuildConfigurationRef> getBuildConfigs() {
        return this.buildConfigs;
    }

    @Override
    @Generated
    public String toString() {
        return "GroupConfiguration(super=" + super.toString() + ", productVersion=" + this.getProductVersion() + ", buildConfigs=" + this.getBuildConfigs() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupConfiguration)) {
            return false;
        }
        GroupConfiguration other = (GroupConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProductVersionRef this$productVersion = this.getProductVersion();
        ProductVersionRef other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !((Object)this$productVersion).equals(other$productVersion)) {
            return false;
        }
        Map<String, BuildConfigurationRef> this$buildConfigs = this.getBuildConfigs();
        Map<String, BuildConfigurationRef> other$buildConfigs = other.getBuildConfigs();
        return !(this$buildConfigs == null ? other$buildConfigs != null : !((Object)this$buildConfigs).equals(other$buildConfigs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProductVersionRef $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : ((Object)$productVersion).hashCode());
        Map<String, BuildConfigurationRef> $buildConfigs = this.getBuildConfigs();
        result = result * 59 + ($buildConfigs == null ? 43 : ((Object)$buildConfigs).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        @Generated
        private ProductVersionRef productVersion;
        @Generated
        private Map<String, BuildConfigurationRef> buildConfigs;
        @Generated
        private String id;
        @Generated
        private String name;

        @Generated
        Builder() {
        }

        @Generated
        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        @Generated
        public Builder buildConfigs(Map<String, BuildConfigurationRef> buildConfigs) {
            this.buildConfigs = buildConfigs;
            return this;
        }

        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public GroupConfiguration build() {
            return new GroupConfiguration(this.productVersion, this.buildConfigs, this.id, this.name);
        }

        @Generated
        public String toString() {
            return "GroupConfiguration.Builder(productVersion=" + this.productVersion + ", buildConfigs=" + this.buildConfigs + ", id=" + this.id + ", name=" + this.name + ")";
        }
    }
}

