/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.client.patch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.AddOperation;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.RemoveOperation;
import com.github.fge.jsonpatch.ReplaceOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.pnc.client.patch.ObjectMapperProvider;
import org.jboss.pnc.client.patch.PatchBuilderException;

public abstract class PatchBase<T, S> {
    protected List<JsonPatchOperation> operations = new ArrayList<JsonPatchOperation>();
    protected ObjectMapper mapper = ObjectMapperProvider.getInstance();
    protected Class<S> clazz;

    public PatchBase(Class<S> clazz) {
        this.clazz = clazz;
    }

    public Class<S> getClazz() {
        return this.clazz;
    }

    public String getJsonPatch() throws PatchBuilderException {
        try {
            return this.mapper.writeValueAsString(this.operations);
        }
        catch (JsonProcessingException e) {
            throw new PatchBuilderException("Cannot serialize patch request.", (Exception)((Object)e));
        }
    }

    protected T add(Collection elements, String path) {
        for (Object element : elements) {
            AddOperation operation = new AddOperation(JsonPointer.of((Object)path, (Object[])new Object[]{"-"}), this.mapper.valueToTree(element));
            this.operations.add((JsonPatchOperation)operation);
        }
        return (T)this;
    }

    protected T add(Map<?, ?> elements, String path) {
        for (Map.Entry<?, ?> entry : elements.entrySet()) {
            AddOperation operation = new AddOperation(JsonPointer.of((Object)path, (Object[])new Object[]{entry.getKey()}), this.mapper.valueToTree(entry.getValue()));
            this.operations.add((JsonPatchOperation)operation);
        }
        return (T)this;
    }

    protected T remove(Collection keys, String path) {
        for (Object key : keys) {
            RemoveOperation operation = new RemoveOperation(JsonPointer.of((Object)path, (Object[])new Object[]{key}));
            this.operations.add((JsonPatchOperation)operation);
        }
        return (T)this;
    }

    protected T replace(Object value, String path) {
        ReplaceOperation operation = new ReplaceOperation(JsonPointer.of((Object)path, (Object[])new Object[0]), this.mapper.valueToTree(value));
        this.operations.add((JsonPatchOperation)operation);
        return (T)this;
    }
}

