/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.dto.Operation;
import org.jboss.pnc.dto.notification.Notification;
import org.jboss.pnc.enums.JobNotificationProgress;
import org.jboss.pnc.enums.JobNotificationType;

public class OperationNotification
extends Notification {
    private final String operationId;
    private final OperationResult result;
    private final Operation operation;

    public OperationNotification(String notificationType, String operationId, ProgressStatus newStatus, ProgressStatus oldStatus, OperationResult result, Operation operation) {
        this(notificationType, operationId, newStatus, oldStatus, null, result, operation);
    }

    @JsonCreator
    public OperationNotification(@JsonProperty(value="notificationType") String notificationType, @JsonProperty(value="operationId") String operationId, @JsonProperty(value="progress") ProgressStatus newStatus, @JsonProperty(value="oldProgress") ProgressStatus oldStatus, @JsonProperty(value="message") String message, @JsonProperty(value="result") OperationResult result, @JsonProperty(value="operation") Operation operation) {
        super(JobNotificationType.OPERATION, notificationType, OperationNotification.convert(newStatus), OperationNotification.convert(oldStatus), message);
        this.operationId = operationId;
        this.result = result;
        this.operation = operation;
    }

    private static JobNotificationProgress convert(ProgressStatus status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case NEW: 
            case PENDING: {
                return JobNotificationProgress.PENDING;
            }
            case IN_PROGRESS: {
                return JobNotificationProgress.IN_PROGRESS;
            }
            case FINISHED: {
                return JobNotificationProgress.FINISHED;
            }
        }
        throw new IllegalArgumentException("Unknown Progress Status.");
    }

    @Generated
    public String getOperationId() {
        return this.operationId;
    }

    @Generated
    public OperationResult getResult() {
        return this.result;
    }

    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationNotification)) {
            return false;
        }
        OperationNotification other = (OperationNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$operationId = this.getOperationId();
        String other$operationId = other.getOperationId();
        if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
            return false;
        }
        OperationResult this$result = this.getResult();
        OperationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)this$operation).equals(other$operation));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperationNotification;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $operationId = this.getOperationId();
        result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
        OperationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)$operation).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "OperationNotification(operationId=" + this.getOperationId() + ", result=" + this.getResult() + ", operation=" + this.getOperation() + ")";
    }
}

