/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.jboss.pnc.common.validator.NoHtml;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildConfigurationWithLatestBuild
extends BuildConfiguration {
    private final BuildRef latestBuild;
    @NoHtml(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String latestBuildUsername;

    private BuildConfigurationWithLatestBuild(SCMRepository scmRepository, ProjectRef project, Environment environment, Map<String, BuildConfigurationRef> dependencies, ProductVersionRef productVersion, Map<String, GroupConfigurationRef> groupConfigs, Map<String, String> parameters, String id, String name, String description, String buildScript, String scmRevision, Instant creationTime, Instant modificationTime, BuildType buildType, User creationUser, User modificationUser, String defaultAlignmentParams, Boolean brewPullActive, BuildRef latestBuild, String latestBuildUsername) {
        super(scmRepository, project, environment, dependencies, productVersion, groupConfigs, parameters, id, name, description, buildScript, scmRevision, creationTime, modificationTime, buildType, creationUser, modificationUser, defaultAlignmentParams, brewPullActive);
        this.latestBuild = latestBuild;
        this.latestBuildUsername = latestBuildUsername;
    }

    @Generated
    public static Builder builderWithLatestBuild() {
        return new Builder();
    }

    @Generated
    public BuildRef getLatestBuild() {
        return this.latestBuild;
    }

    @Generated
    public String getLatestBuildUsername() {
        return this.latestBuildUsername;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfigurationWithLatestBuild)) {
            return false;
        }
        BuildConfigurationWithLatestBuild other = (BuildConfigurationWithLatestBuild)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BuildRef this$latestBuild = this.getLatestBuild();
        BuildRef other$latestBuild = other.getLatestBuild();
        if (this$latestBuild == null ? other$latestBuild != null : !((Object)this$latestBuild).equals(other$latestBuild)) {
            return false;
        }
        String this$latestBuildUsername = this.getLatestBuildUsername();
        String other$latestBuildUsername = other.getLatestBuildUsername();
        return !(this$latestBuildUsername == null ? other$latestBuildUsername != null : !this$latestBuildUsername.equals(other$latestBuildUsername));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildConfigurationWithLatestBuild;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuildRef $latestBuild = this.getLatestBuild();
        result = result * 59 + ($latestBuild == null ? 43 : ((Object)$latestBuild).hashCode());
        String $latestBuildUsername = this.getLatestBuildUsername();
        result = result * 59 + ($latestBuildUsername == null ? 43 : $latestBuildUsername.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BuildConfigurationWithLatestBuild(super=" + super.toString() + ", latestBuild=" + this.getLatestBuild() + ", latestBuildUsername=" + this.getLatestBuildUsername() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        @Generated
        private SCMRepository scmRepository;
        @Generated
        private ProjectRef project;
        @Generated
        private Environment environment;
        @Generated
        private Map<String, BuildConfigurationRef> dependencies;
        @Generated
        private ProductVersionRef productVersion;
        @Generated
        private Map<String, GroupConfigurationRef> groupConfigs;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String buildScript;
        @Generated
        private String scmRevision;
        @Generated
        private Instant creationTime;
        @Generated
        private Instant modificationTime;
        @Generated
        private BuildType buildType;
        @Generated
        private User creationUser;
        @Generated
        private User modificationUser;
        @Generated
        private String defaultAlignmentParams;
        @Generated
        private Boolean brewPullActive;
        @Generated
        private BuildRef latestBuild;
        @Generated
        private String latestBuildUsername;

        public Builder buildConfig(BuildConfiguration buildConfiguration) {
            this.id = buildConfiguration.id;
            this.name = buildConfiguration.name;
            this.description = buildConfiguration.description;
            this.buildScript = buildConfiguration.buildScript;
            this.scmRevision = buildConfiguration.scmRevision;
            this.creationTime = buildConfiguration.creationTime;
            this.modificationTime = buildConfiguration.modificationTime;
            this.buildType = buildConfiguration.buildType;
            this.defaultAlignmentParams = buildConfiguration.defaultAlignmentParams;
            this.brewPullActive = buildConfiguration.brewPullActive;
            this.scmRepository = buildConfiguration.scmRepository;
            this.project = buildConfiguration.project;
            this.environment = buildConfiguration.environment;
            this.dependencies = buildConfiguration.dependencies;
            this.productVersion = buildConfiguration.productVersion;
            this.groupConfigs = buildConfiguration.groupConfigs;
            this.parameters = buildConfiguration.parameters;
            this.creationUser = buildConfiguration.creationUser;
            this.modificationUser = buildConfiguration.modificationUser;
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public Builder scmRepository(SCMRepository scmRepository) {
            this.scmRepository = scmRepository;
            return this;
        }

        @Generated
        public Builder project(ProjectRef project) {
            this.project = project;
            return this;
        }

        @Generated
        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public Builder dependencies(Map<String, BuildConfigurationRef> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Generated
        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        @Generated
        public Builder groupConfigs(Map<String, GroupConfigurationRef> groupConfigs) {
            this.groupConfigs = groupConfigs;
            return this;
        }

        @Generated
        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public Builder buildScript(String buildScript) {
            this.buildScript = buildScript;
            return this;
        }

        @Generated
        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        @Generated
        public Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Generated
        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        @Generated
        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        @Generated
        public Builder creationUser(User creationUser) {
            this.creationUser = creationUser;
            return this;
        }

        @Generated
        public Builder modificationUser(User modificationUser) {
            this.modificationUser = modificationUser;
            return this;
        }

        @Generated
        public Builder defaultAlignmentParams(String defaultAlignmentParams) {
            this.defaultAlignmentParams = defaultAlignmentParams;
            return this;
        }

        @Generated
        public Builder brewPullActive(Boolean brewPullActive) {
            this.brewPullActive = brewPullActive;
            return this;
        }

        @Generated
        public Builder latestBuild(BuildRef latestBuild) {
            this.latestBuild = latestBuild;
            return this;
        }

        @Generated
        public Builder latestBuildUsername(String latestBuildUsername) {
            this.latestBuildUsername = latestBuildUsername;
            return this;
        }

        @Generated
        public BuildConfigurationWithLatestBuild build() {
            return new BuildConfigurationWithLatestBuild(this.scmRepository, this.project, this.environment, this.dependencies, this.productVersion, this.groupConfigs, this.parameters, this.id, this.name, this.description, this.buildScript, this.scmRevision, this.creationTime, this.modificationTime, this.buildType, this.creationUser, this.modificationUser, this.defaultAlignmentParams, this.brewPullActive, this.latestBuild, this.latestBuildUsername);
        }

        @Generated
        public String toString() {
            return "BuildConfigurationWithLatestBuild.Builder(scmRepository=" + this.scmRepository + ", project=" + this.project + ", environment=" + this.environment + ", dependencies=" + this.dependencies + ", productVersion=" + this.productVersion + ", groupConfigs=" + this.groupConfigs + ", parameters=" + this.parameters + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", buildScript=" + this.buildScript + ", scmRevision=" + this.scmRevision + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", buildType=" + this.buildType + ", creationUser=" + this.creationUser + ", modificationUser=" + this.modificationUser + ", defaultAlignmentParams=" + this.defaultAlignmentParams + ", brewPullActive=" + this.brewPullActive + ", latestBuild=" + this.latestBuild + ", latestBuildUsername=" + this.latestBuildUsername + ")";
        }
    }
}

