/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.dto.BuildConfigurationRevisionRef;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.GroupBuildRef;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.enums.BuildProgress;
import org.jboss.pnc.enums.BuildStatus;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Build
extends BuildRef {
    private final ProjectRef project;
    private final SCMRepository scmRepository;
    private final Environment environment;
    private final Map<String, String> attributes;
    private final User user;
    private final BuildConfigurationRevisionRef buildConfigRevision;
    private final ProductMilestoneRef productMilestone;
    private final GroupBuildRef groupBuild;
    private final BuildRef noRebuildCause;

    private Build(ProjectRef project, SCMRepository scmRepository, Environment environment, Map<String, String> attributes, User user, BuildConfigurationRevisionRef buildConfigRevision, String id, Instant submitTime, Instant startTime, Instant endTime, BuildProgress progress, BuildStatus status, String buildContentId, Boolean temporaryBuild, AlignmentPreference alignmentPreference, String scmUrl, String scmRevision, String scmTag, GroupBuildRef groupBuild, ProductMilestoneRef productMilestone, String buildOutputChecksum, BuildRef noRebuildCause, Instant lastUpdateTime, String scmBuildConfigRevision, Boolean scmBuildConfigRevisionInternal) {
        super(id, submitTime, startTime, endTime, progress, status, buildContentId, temporaryBuild, alignmentPreference, scmUrl, scmRevision, scmTag, buildOutputChecksum, lastUpdateTime, scmBuildConfigRevision, scmBuildConfigRevisionInternal);
        this.project = project;
        this.scmRepository = scmRepository;
        this.environment = environment;
        this.attributes = attributes;
        this.user = user;
        this.buildConfigRevision = buildConfigRevision;
        this.productMilestone = productMilestone;
        this.groupBuild = groupBuild;
        this.noRebuildCause = noRebuildCause;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().project(this.project).scmRepository(this.scmRepository).environment(this.environment).attributes(this.attributes).user(this.user).buildConfigRevision(this.buildConfigRevision).id(this.id).submitTime(this.submitTime).startTime(this.startTime).endTime(this.endTime).progress(this.progress).status(this.status).buildContentId(this.buildContentId).temporaryBuild(this.temporaryBuild).alignmentPreference(this.alignmentPreference).scmUrl(this.scmUrl).scmRevision(this.scmRevision).scmTag(this.scmTag).groupBuild(this.groupBuild).productMilestone(this.productMilestone).buildOutputChecksum(this.buildOutputChecksum).noRebuildCause(this.noRebuildCause).lastUpdateTime(this.lastUpdateTime).scmBuildConfigRevision(this.scmBuildConfigRevision).scmBuildConfigRevisionInternal(this.scmBuildConfigRevisionInternal);
    }

    @Generated
    public ProjectRef getProject() {
        return this.project;
    }

    @Generated
    public SCMRepository getScmRepository() {
        return this.scmRepository;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public BuildConfigurationRevisionRef getBuildConfigRevision() {
        return this.buildConfigRevision;
    }

    @Generated
    public ProductMilestoneRef getProductMilestone() {
        return this.productMilestone;
    }

    @Generated
    public GroupBuildRef getGroupBuild() {
        return this.groupBuild;
    }

    @Generated
    public BuildRef getNoRebuildCause() {
        return this.noRebuildCause;
    }

    @Override
    @Generated
    public String toString() {
        return "Build(super=" + super.toString() + ", project=" + this.getProject() + ", scmRepository=" + this.getScmRepository() + ", environment=" + this.getEnvironment() + ", attributes=" + this.getAttributes() + ", user=" + this.getUser() + ", buildConfigRevision=" + this.getBuildConfigRevision() + ", productMilestone=" + this.getProductMilestone() + ", groupBuild=" + this.getGroupBuild() + ", noRebuildCause=" + this.getNoRebuildCause() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Build)) {
            return false;
        }
        Build other = (Build)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectRef this$project = this.getProject();
        ProjectRef other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        SCMRepository this$scmRepository = this.getScmRepository();
        SCMRepository other$scmRepository = other.getScmRepository();
        if (this$scmRepository == null ? other$scmRepository != null : !((Object)this$scmRepository).equals(other$scmRepository)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        BuildConfigurationRevisionRef this$buildConfigRevision = this.getBuildConfigRevision();
        BuildConfigurationRevisionRef other$buildConfigRevision = other.getBuildConfigRevision();
        if (this$buildConfigRevision == null ? other$buildConfigRevision != null : !((Object)this$buildConfigRevision).equals(other$buildConfigRevision)) {
            return false;
        }
        ProductMilestoneRef this$productMilestone = this.getProductMilestone();
        ProductMilestoneRef other$productMilestone = other.getProductMilestone();
        if (this$productMilestone == null ? other$productMilestone != null : !((Object)this$productMilestone).equals(other$productMilestone)) {
            return false;
        }
        GroupBuildRef this$groupBuild = this.getGroupBuild();
        GroupBuildRef other$groupBuild = other.getGroupBuild();
        if (this$groupBuild == null ? other$groupBuild != null : !((Object)this$groupBuild).equals(other$groupBuild)) {
            return false;
        }
        BuildRef this$noRebuildCause = this.getNoRebuildCause();
        BuildRef other$noRebuildCause = other.getNoRebuildCause();
        return !(this$noRebuildCause == null ? other$noRebuildCause != null : !((Object)this$noRebuildCause).equals(other$noRebuildCause));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Build;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProjectRef $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        SCMRepository $scmRepository = this.getScmRepository();
        result = result * 59 + ($scmRepository == null ? 43 : ((Object)$scmRepository).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        BuildConfigurationRevisionRef $buildConfigRevision = this.getBuildConfigRevision();
        result = result * 59 + ($buildConfigRevision == null ? 43 : ((Object)$buildConfigRevision).hashCode());
        ProductMilestoneRef $productMilestone = this.getProductMilestone();
        result = result * 59 + ($productMilestone == null ? 43 : ((Object)$productMilestone).hashCode());
        GroupBuildRef $groupBuild = this.getGroupBuild();
        result = result * 59 + ($groupBuild == null ? 43 : ((Object)$groupBuild).hashCode());
        BuildRef $noRebuildCause = this.getNoRebuildCause();
        result = result * 59 + ($noRebuildCause == null ? 43 : ((Object)$noRebuildCause).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        @Generated
        private ProjectRef project;
        @Generated
        private SCMRepository scmRepository;
        @Generated
        private Environment environment;
        @Generated
        private Map<String, String> attributes;
        @Generated
        private User user;
        @Generated
        private BuildConfigurationRevisionRef buildConfigRevision;
        @Generated
        private String id;
        @Generated
        private Instant submitTime;
        @Generated
        private Instant startTime;
        @Generated
        private Instant endTime;
        @Generated
        private BuildProgress progress;
        @Generated
        private BuildStatus status;
        @Generated
        private String buildContentId;
        @Generated
        private Boolean temporaryBuild;
        @Generated
        private AlignmentPreference alignmentPreference;
        @Generated
        private String scmUrl;
        @Generated
        private String scmRevision;
        @Generated
        private String scmTag;
        @Generated
        private GroupBuildRef groupBuild;
        @Generated
        private ProductMilestoneRef productMilestone;
        @Generated
        private String buildOutputChecksum;
        @Generated
        private BuildRef noRebuildCause;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private String scmBuildConfigRevision;
        @Generated
        private Boolean scmBuildConfigRevisionInternal;

        @Generated
        Builder() {
        }

        @Generated
        public Builder project(ProjectRef project) {
            this.project = project;
            return this;
        }

        @Generated
        public Builder scmRepository(SCMRepository scmRepository) {
            this.scmRepository = scmRepository;
            return this;
        }

        @Generated
        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public Builder user(User user) {
            this.user = user;
            return this;
        }

        @Generated
        public Builder buildConfigRevision(BuildConfigurationRevisionRef buildConfigRevision) {
            this.buildConfigRevision = buildConfigRevision;
            return this;
        }

        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        @Generated
        public Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Generated
        public Builder progress(BuildProgress progress) {
            this.progress = progress;
            return this;
        }

        @Generated
        public Builder status(BuildStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public Builder buildContentId(String buildContentId) {
            this.buildContentId = buildContentId;
            return this;
        }

        @Generated
        public Builder temporaryBuild(Boolean temporaryBuild) {
            this.temporaryBuild = temporaryBuild;
            return this;
        }

        @Generated
        public Builder alignmentPreference(AlignmentPreference alignmentPreference) {
            this.alignmentPreference = alignmentPreference;
            return this;
        }

        @Generated
        public Builder scmUrl(String scmUrl) {
            this.scmUrl = scmUrl;
            return this;
        }

        @Generated
        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        @Generated
        public Builder scmTag(String scmTag) {
            this.scmTag = scmTag;
            return this;
        }

        @Generated
        public Builder groupBuild(GroupBuildRef groupBuild) {
            this.groupBuild = groupBuild;
            return this;
        }

        @Generated
        public Builder productMilestone(ProductMilestoneRef productMilestone) {
            this.productMilestone = productMilestone;
            return this;
        }

        @Generated
        public Builder buildOutputChecksum(String buildOutputChecksum) {
            this.buildOutputChecksum = buildOutputChecksum;
            return this;
        }

        @Generated
        public Builder noRebuildCause(BuildRef noRebuildCause) {
            this.noRebuildCause = noRebuildCause;
            return this;
        }

        @Generated
        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public Builder scmBuildConfigRevision(String scmBuildConfigRevision) {
            this.scmBuildConfigRevision = scmBuildConfigRevision;
            return this;
        }

        @Generated
        public Builder scmBuildConfigRevisionInternal(Boolean scmBuildConfigRevisionInternal) {
            this.scmBuildConfigRevisionInternal = scmBuildConfigRevisionInternal;
            return this;
        }

        @Generated
        public Build build() {
            return new Build(this.project, this.scmRepository, this.environment, this.attributes, this.user, this.buildConfigRevision, this.id, this.submitTime, this.startTime, this.endTime, this.progress, this.status, this.buildContentId, this.temporaryBuild, this.alignmentPreference, this.scmUrl, this.scmRevision, this.scmTag, this.groupBuild, this.productMilestone, this.buildOutputChecksum, this.noRebuildCause, this.lastUpdateTime, this.scmBuildConfigRevision, this.scmBuildConfigRevisionInternal);
        }

        @Generated
        public String toString() {
            return "Build.Builder(project=" + this.project + ", scmRepository=" + this.scmRepository + ", environment=" + this.environment + ", attributes=" + this.attributes + ", user=" + this.user + ", buildConfigRevision=" + this.buildConfigRevision + ", id=" + this.id + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", progress=" + this.progress + ", status=" + this.status + ", buildContentId=" + this.buildContentId + ", temporaryBuild=" + this.temporaryBuild + ", alignmentPreference=" + this.alignmentPreference + ", scmUrl=" + this.scmUrl + ", scmRevision=" + this.scmRevision + ", scmTag=" + this.scmTag + ", groupBuild=" + this.groupBuild + ", productMilestone=" + this.productMilestone + ", buildOutputChecksum=" + this.buildOutputChecksum + ", noRebuildCause=" + this.noRebuildCause + ", lastUpdateTime=" + this.lastUpdateTime + ", scmBuildConfigRevision=" + this.scmBuildConfigRevision + ", scmBuildConfigRevisionInternal=" + this.scmBuildConfigRevisionInternal + ")";
        }
    }
}

