package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.String;
import java.time.Instant;
import org.jboss.pnc.dto.ProductMilestone;

public class ProductMilestonePatchBuilder extends PatchBase<ProductMilestonePatchBuilder, ProductMilestone> {
  public ProductMilestonePatchBuilder() {
    super(org.jboss.pnc.dto.ProductMilestone.class);
  }

  public ProductMilestonePatchBuilder replaceVersion(String element) throws PatchBuilderException {
    try {
      return replace(element, "version");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductMilestonePatchBuilder replaceEndDate(Instant element) throws PatchBuilderException {
    try {
      return replace(element, "endDate");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductMilestonePatchBuilder replaceStartingDate(Instant element) throws
      PatchBuilderException {
    try {
      return replace(element, "startingDate");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductMilestonePatchBuilder replacePlannedEndDate(Instant element) throws
      PatchBuilderException {
    try {
      return replace(element, "plannedEndDate");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
