/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.validation.constraints.RefHasId;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildConfiguration
extends BuildConfigurationRef {
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final SCMRepository scmRepository;
    @RefHasId(groups={WhenCreatingNew.class})
    protected final ProjectRef project;
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final Environment environment;
    protected final Map<String, BuildConfigurationRef> dependencies;
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class}, optional=true)
    protected final ProductVersionRef productVersion;
    protected final Map<String, GroupConfigurationRef> groupConfigs;
    protected final Map<String, String> parameters;
    protected final User creationUser;
    protected final User modificationUser;

    protected BuildConfiguration(SCMRepository scmRepository, ProjectRef project, Environment environment, Map<String, BuildConfigurationRef> dependencies, ProductVersionRef productVersion, Map<String, GroupConfigurationRef> groupConfigs, Map<String, String> parameters, String id, String name, String description, String buildScript, String scmRevision, Instant creationTime, Instant modificationTime, BuildType buildType, User creationUser, User modificationUser, String defaultAlignmentParams, Boolean brewPullActive) {
        super(id, name, description, buildScript, scmRevision, creationTime, modificationTime, buildType, defaultAlignmentParams, brewPullActive);
        this.scmRepository = scmRepository;
        this.project = project;
        this.environment = environment;
        this.dependencies = dependencies;
        this.productVersion = productVersion;
        this.groupConfigs = groupConfigs;
        this.parameters = parameters;
        this.creationUser = creationUser;
        this.modificationUser = modificationUser;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().scmRepository(this.scmRepository).project(this.project).environment(this.environment).dependencies(this.dependencies).productVersion(this.productVersion).groupConfigs(this.groupConfigs).parameters(this.parameters).id(this.id).name(this.name).description(this.description).buildScript(this.buildScript).scmRevision(this.scmRevision).creationTime(this.creationTime).modificationTime(this.modificationTime).buildType(this.buildType).creationUser(this.creationUser).modificationUser(this.modificationUser).defaultAlignmentParams(this.defaultAlignmentParams).brewPullActive(this.brewPullActive);
    }

    @Generated
    public SCMRepository getScmRepository() {
        return this.scmRepository;
    }

    @Generated
    public ProjectRef getProject() {
        return this.project;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public Map<String, BuildConfigurationRef> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public ProductVersionRef getProductVersion() {
        return this.productVersion;
    }

    @Generated
    public Map<String, GroupConfigurationRef> getGroupConfigs() {
        return this.groupConfigs;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public User getCreationUser() {
        return this.creationUser;
    }

    @Generated
    public User getModificationUser() {
        return this.modificationUser;
    }

    @Override
    @Generated
    public String toString() {
        return "BuildConfiguration(super=" + super.toString() + ", scmRepository=" + this.getScmRepository() + ", project=" + this.getProject() + ", environment=" + this.getEnvironment() + ", dependencies=" + this.getDependencies() + ", productVersion=" + this.getProductVersion() + ", groupConfigs=" + this.getGroupConfigs() + ", parameters=" + this.getParameters() + ", creationUser=" + this.getCreationUser() + ", modificationUser=" + this.getModificationUser() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfiguration)) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SCMRepository this$scmRepository = this.getScmRepository();
        SCMRepository other$scmRepository = other.getScmRepository();
        if (this$scmRepository == null ? other$scmRepository != null : !((Object)this$scmRepository).equals(other$scmRepository)) {
            return false;
        }
        ProjectRef this$project = this.getProject();
        ProjectRef other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        Map<String, BuildConfigurationRef> this$dependencies = this.getDependencies();
        Map<String, BuildConfigurationRef> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        ProductVersionRef this$productVersion = this.getProductVersion();
        ProductVersionRef other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !((Object)this$productVersion).equals(other$productVersion)) {
            return false;
        }
        Map<String, GroupConfigurationRef> this$groupConfigs = this.getGroupConfigs();
        Map<String, GroupConfigurationRef> other$groupConfigs = other.getGroupConfigs();
        if (this$groupConfigs == null ? other$groupConfigs != null : !((Object)this$groupConfigs).equals(other$groupConfigs)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        User this$creationUser = this.getCreationUser();
        User other$creationUser = other.getCreationUser();
        if (this$creationUser == null ? other$creationUser != null : !((Object)this$creationUser).equals(other$creationUser)) {
            return false;
        }
        User this$modificationUser = this.getModificationUser();
        User other$modificationUser = other.getModificationUser();
        return !(this$modificationUser == null ? other$modificationUser != null : !((Object)this$modificationUser).equals(other$modificationUser));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SCMRepository $scmRepository = this.getScmRepository();
        result = result * 59 + ($scmRepository == null ? 43 : ((Object)$scmRepository).hashCode());
        ProjectRef $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        Map<String, BuildConfigurationRef> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        ProductVersionRef $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : ((Object)$productVersion).hashCode());
        Map<String, GroupConfigurationRef> $groupConfigs = this.getGroupConfigs();
        result = result * 59 + ($groupConfigs == null ? 43 : ((Object)$groupConfigs).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        User $creationUser = this.getCreationUser();
        result = result * 59 + ($creationUser == null ? 43 : ((Object)$creationUser).hashCode());
        User $modificationUser = this.getModificationUser();
        result = result * 59 + ($modificationUser == null ? 43 : ((Object)$modificationUser).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        @Generated
        private SCMRepository scmRepository;
        @Generated
        private ProjectRef project;
        @Generated
        private Environment environment;
        @Generated
        private Map<String, BuildConfigurationRef> dependencies;
        @Generated
        private ProductVersionRef productVersion;
        @Generated
        private Map<String, GroupConfigurationRef> groupConfigs;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String buildScript;
        @Generated
        private String scmRevision;
        @Generated
        private Instant creationTime;
        @Generated
        private Instant modificationTime;
        @Generated
        private BuildType buildType;
        @Generated
        private User creationUser;
        @Generated
        private User modificationUser;
        @Generated
        private String defaultAlignmentParams;
        @Generated
        private Boolean brewPullActive;

        @Generated
        Builder() {
        }

        @Generated
        public Builder scmRepository(SCMRepository scmRepository) {
            this.scmRepository = scmRepository;
            return this;
        }

        @Generated
        public Builder project(ProjectRef project) {
            this.project = project;
            return this;
        }

        @Generated
        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public Builder dependencies(Map<String, BuildConfigurationRef> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Generated
        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        @Generated
        public Builder groupConfigs(Map<String, GroupConfigurationRef> groupConfigs) {
            this.groupConfigs = groupConfigs;
            return this;
        }

        @Generated
        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public Builder buildScript(String buildScript) {
            this.buildScript = buildScript;
            return this;
        }

        @Generated
        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        @Generated
        public Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Generated
        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        @Generated
        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        @Generated
        public Builder creationUser(User creationUser) {
            this.creationUser = creationUser;
            return this;
        }

        @Generated
        public Builder modificationUser(User modificationUser) {
            this.modificationUser = modificationUser;
            return this;
        }

        @Generated
        public Builder defaultAlignmentParams(String defaultAlignmentParams) {
            this.defaultAlignmentParams = defaultAlignmentParams;
            return this;
        }

        @Generated
        public Builder brewPullActive(Boolean brewPullActive) {
            this.brewPullActive = brewPullActive;
            return this;
        }

        @Generated
        public BuildConfiguration build() {
            return new BuildConfiguration(this.scmRepository, this.project, this.environment, this.dependencies, this.productVersion, this.groupConfigs, this.parameters, this.id, this.name, this.description, this.buildScript, this.scmRevision, this.creationTime, this.modificationTime, this.buildType, this.creationUser, this.modificationUser, this.defaultAlignmentParams, this.brewPullActive);
        }

        @Generated
        public String toString() {
            return "BuildConfiguration.Builder(scmRepository=" + this.scmRepository + ", project=" + this.project + ", environment=" + this.environment + ", dependencies=" + this.dependencies + ", productVersion=" + this.productVersion + ", groupConfigs=" + this.groupConfigs + ", parameters=" + this.parameters + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", buildScript=" + this.buildScript + ", scmRevision=" + this.scmRevision + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", buildType=" + this.buildType + ", creationUser=" + this.creationUser + ", modificationUser=" + this.modificationUser + ", defaultAlignmentParams=" + this.defaultAlignmentParams + ", brewPullActive=" + this.brewPullActive + ")";
        }
    }
}

