package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.Object;
import java.lang.String;
import java.util.Collection;
import java.util.Map;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.ProductVersionRef;

public class GroupConfigurationPatchBuilder extends PatchBase<GroupConfigurationPatchBuilder, GroupConfiguration> {
  public GroupConfigurationPatchBuilder() {
    super(org.jboss.pnc.dto.GroupConfiguration.class);
  }

  public GroupConfigurationPatchBuilder replaceProductVersion(ProductVersionRef element) throws
      PatchBuilderException {
    try {
      return replace(element, "productVersion");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public GroupConfigurationPatchBuilder addBuildConfigs(Map<String, BuildConfigurationRef> elements)
      throws PatchBuilderException {
    try {
      return add(elements, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public GroupConfigurationPatchBuilder replaceBuildConfigs(
      Map<String, BuildConfigurationRef> element) throws PatchBuilderException {
    try {
      return replace(element, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public GroupConfigurationPatchBuilder removeBuildConfigs(Collection<Object> keys) throws
      PatchBuilderException {
    try {
      return remove(keys, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public GroupConfigurationPatchBuilder replaceName(String element) throws PatchBuilderException {
    try {
      return replace(element, "name");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
