/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Map;
import lombok.Generated;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProductRef;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.validation.constraints.RefHasId;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class ProductVersion
extends ProductVersionRef {
    @RefHasId(groups={WhenCreatingNew.class})
    private final ProductRef product;
    private final ProductMilestoneRef currentProductMilestone;
    private final Map<String, ProductMilestoneRef> productMilestones;
    private final Map<String, ProductReleaseRef> productReleases;
    private final Map<String, GroupConfigurationRef> groupConfigs;
    private final Map<String, BuildConfigurationRef> buildConfigs;

    private ProductVersion(ProductRef product, ProductMilestoneRef currentProductMilestone, Map<String, ProductMilestoneRef> productMilestones, Map<String, ProductReleaseRef> productReleases, Map<String, GroupConfigurationRef> groupConfigs, Map<String, BuildConfigurationRef> buildConfigs, String id, String version, Map<String, String> attributes) {
        super(id, version, attributes);
        this.product = product;
        this.currentProductMilestone = currentProductMilestone;
        this.productMilestones = productMilestones;
        this.productReleases = productReleases;
        this.groupConfigs = groupConfigs;
        this.buildConfigs = buildConfigs;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().product(this.product).currentProductMilestone(this.currentProductMilestone).productMilestones(this.productMilestones).productReleases(this.productReleases).groupConfigs(this.groupConfigs).buildConfigs(this.buildConfigs).id(this.id).version(this.version).attributes(this.attributes);
    }

    @Generated
    public ProductRef getProduct() {
        return this.product;
    }

    @Generated
    public ProductMilestoneRef getCurrentProductMilestone() {
        return this.currentProductMilestone;
    }

    @Generated
    public Map<String, ProductMilestoneRef> getProductMilestones() {
        return this.productMilestones;
    }

    @Generated
    public Map<String, ProductReleaseRef> getProductReleases() {
        return this.productReleases;
    }

    @Generated
    public Map<String, GroupConfigurationRef> getGroupConfigs() {
        return this.groupConfigs;
    }

    @Generated
    public Map<String, BuildConfigurationRef> getBuildConfigs() {
        return this.buildConfigs;
    }

    @Override
    @Generated
    public String toString() {
        return "ProductVersion(super=" + super.toString() + ", product=" + this.getProduct() + ", currentProductMilestone=" + this.getCurrentProductMilestone() + ", productMilestones=" + this.getProductMilestones() + ", productReleases=" + this.getProductReleases() + ", groupConfigs=" + this.getGroupConfigs() + ", buildConfigs=" + this.getBuildConfigs() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductVersion)) {
            return false;
        }
        ProductVersion other = (ProductVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProductRef this$product = this.getProduct();
        ProductRef other$product = other.getProduct();
        if (this$product == null ? other$product != null : !((Object)this$product).equals(other$product)) {
            return false;
        }
        ProductMilestoneRef this$currentProductMilestone = this.getCurrentProductMilestone();
        ProductMilestoneRef other$currentProductMilestone = other.getCurrentProductMilestone();
        if (this$currentProductMilestone == null ? other$currentProductMilestone != null : !((Object)this$currentProductMilestone).equals(other$currentProductMilestone)) {
            return false;
        }
        Map<String, ProductMilestoneRef> this$productMilestones = this.getProductMilestones();
        Map<String, ProductMilestoneRef> other$productMilestones = other.getProductMilestones();
        if (this$productMilestones == null ? other$productMilestones != null : !((Object)this$productMilestones).equals(other$productMilestones)) {
            return false;
        }
        Map<String, ProductReleaseRef> this$productReleases = this.getProductReleases();
        Map<String, ProductReleaseRef> other$productReleases = other.getProductReleases();
        if (this$productReleases == null ? other$productReleases != null : !((Object)this$productReleases).equals(other$productReleases)) {
            return false;
        }
        Map<String, GroupConfigurationRef> this$groupConfigs = this.getGroupConfigs();
        Map<String, GroupConfigurationRef> other$groupConfigs = other.getGroupConfigs();
        if (this$groupConfigs == null ? other$groupConfigs != null : !((Object)this$groupConfigs).equals(other$groupConfigs)) {
            return false;
        }
        Map<String, BuildConfigurationRef> this$buildConfigs = this.getBuildConfigs();
        Map<String, BuildConfigurationRef> other$buildConfigs = other.getBuildConfigs();
        return !(this$buildConfigs == null ? other$buildConfigs != null : !((Object)this$buildConfigs).equals(other$buildConfigs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProductVersion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProductRef $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        ProductMilestoneRef $currentProductMilestone = this.getCurrentProductMilestone();
        result = result * 59 + ($currentProductMilestone == null ? 43 : ((Object)$currentProductMilestone).hashCode());
        Map<String, ProductMilestoneRef> $productMilestones = this.getProductMilestones();
        result = result * 59 + ($productMilestones == null ? 43 : ((Object)$productMilestones).hashCode());
        Map<String, ProductReleaseRef> $productReleases = this.getProductReleases();
        result = result * 59 + ($productReleases == null ? 43 : ((Object)$productReleases).hashCode());
        Map<String, GroupConfigurationRef> $groupConfigs = this.getGroupConfigs();
        result = result * 59 + ($groupConfigs == null ? 43 : ((Object)$groupConfigs).hashCode());
        Map<String, BuildConfigurationRef> $buildConfigs = this.getBuildConfigs();
        result = result * 59 + ($buildConfigs == null ? 43 : ((Object)$buildConfigs).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        @Generated
        private ProductRef product;
        @Generated
        private ProductMilestoneRef currentProductMilestone;
        @Generated
        private Map<String, ProductMilestoneRef> productMilestones;
        @Generated
        private Map<String, ProductReleaseRef> productReleases;
        @Generated
        private Map<String, GroupConfigurationRef> groupConfigs;
        @Generated
        private Map<String, BuildConfigurationRef> buildConfigs;
        @Generated
        private String id;
        @Generated
        private String version;
        @Generated
        private Map<String, String> attributes;

        @Generated
        Builder() {
        }

        @Generated
        public Builder product(ProductRef product) {
            this.product = product;
            return this;
        }

        @Generated
        public Builder currentProductMilestone(ProductMilestoneRef currentProductMilestone) {
            this.currentProductMilestone = currentProductMilestone;
            return this;
        }

        @Generated
        public Builder productMilestones(Map<String, ProductMilestoneRef> productMilestones) {
            this.productMilestones = productMilestones;
            return this;
        }

        @Generated
        public Builder productReleases(Map<String, ProductReleaseRef> productReleases) {
            this.productReleases = productReleases;
            return this;
        }

        @Generated
        public Builder groupConfigs(Map<String, GroupConfigurationRef> groupConfigs) {
            this.groupConfigs = groupConfigs;
            return this;
        }

        @Generated
        public Builder buildConfigs(Map<String, BuildConfigurationRef> buildConfigs) {
            this.buildConfigs = buildConfigs;
            return this;
        }

        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public ProductVersion build() {
            return new ProductVersion(this.product, this.currentProductMilestone, this.productMilestones, this.productReleases, this.groupConfigs, this.buildConfigs, this.id, this.version, this.attributes);
        }

        @Generated
        public String toString() {
            return "ProductVersion.Builder(product=" + this.product + ", currentProductMilestone=" + this.currentProductMilestone + ", productMilestones=" + this.productMilestones + ", productReleases=" + this.productReleases + ", groupConfigs=" + this.groupConfigs + ", buildConfigs=" + this.buildConfigs + ", id=" + this.id + ", version=" + this.version + ", attributes=" + this.attributes + ")";
        }
    }
}

