package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.Object;
import java.lang.String;
import java.util.Collection;
import java.util.Map;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProductRef;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.dto.ProductVersion;

public class ProductVersionPatchBuilder extends PatchBase<ProductVersionPatchBuilder, ProductVersion> {
  public ProductVersionPatchBuilder() {
    super(org.jboss.pnc.dto.ProductVersion.class);
  }

  public ProductVersionPatchBuilder replaceProduct(ProductRef element) throws
      PatchBuilderException {
    try {
      return replace(element, "product");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder replaceCurrentProductMilestone(ProductMilestoneRef element)
      throws PatchBuilderException {
    try {
      return replace(element, "currentProductMilestone");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder addProductMilestones(Map<String, ProductMilestoneRef> elements)
      throws PatchBuilderException {
    try {
      return add(elements, "productMilestones");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder replaceProductMilestones(
      Map<String, ProductMilestoneRef> element) throws PatchBuilderException {
    try {
      return replace(element, "productMilestones");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder addProductReleases(Map<String, ProductReleaseRef> elements)
      throws PatchBuilderException {
    try {
      return add(elements, "productReleases");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder replaceProductReleases(Map<String, ProductReleaseRef> element)
      throws PatchBuilderException {
    try {
      return replace(element, "productReleases");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder addGroupConfigs(Map<String, GroupConfigurationRef> elements)
      throws PatchBuilderException {
    try {
      return add(elements, "groupConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder replaceGroupConfigs(Map<String, GroupConfigurationRef> element)
      throws PatchBuilderException {
    try {
      return replace(element, "groupConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder removeGroupConfigs(Collection<Object> keys) throws
      PatchBuilderException {
    try {
      return remove(keys, "groupConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder addBuildConfigs(Map<String, BuildConfigurationRef> elements)
      throws PatchBuilderException {
    try {
      return add(elements, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder replaceBuildConfigs(Map<String, BuildConfigurationRef> element)
      throws PatchBuilderException {
    try {
      return replace(element, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder removeBuildConfigs(Collection<Object> keys) throws
      PatchBuilderException {
    try {
      return remove(keys, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder replaceVersion(String element) throws PatchBuilderException {
    try {
      return replace(element, "version");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder addAttributes(Map<String, String> elements) throws
      PatchBuilderException {
    try {
      return add(elements, "attributes");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder removeAttributes(Collection<Object> keys) throws
      PatchBuilderException {
    try {
      return remove(keys, "attributes");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductVersionPatchBuilder replaceAttributes(Map<String, String> element) throws
      PatchBuilderException {
    try {
      return replace(element, "attributes");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
