/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.notification.Notification;
import org.jboss.pnc.enums.BuildProgress;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.enums.JobNotificationProgress;
import org.jboss.pnc.enums.JobNotificationType;

public class BuildChangedNotification
extends Notification {
    private static final String BUILD_STATUS_CHANGED = "BUILD_STATUS_CHANGED";
    private final BuildStatus oldStatus;
    private final Build build;

    @JsonCreator
    public BuildChangedNotification(@JsonProperty(value="oldStatus") BuildStatus oldStatus, @JsonProperty(value="build") Build build) {
        super(JobNotificationType.BUILD, BUILD_STATUS_CHANGED, BuildChangedNotification.getProgress(build.getStatus().progress()), BuildChangedNotification.getProgress(oldStatus.progress()));
        this.oldStatus = oldStatus;
        this.build = build;
    }

    public static JobNotificationProgress getProgress(BuildProgress status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case PENDING: {
                return JobNotificationProgress.PENDING;
            }
            case FINISHED: {
                return JobNotificationProgress.FINISHED;
            }
            case IN_PROGRESS: {
                return JobNotificationProgress.IN_PROGRESS;
            }
        }
        throw new UnsupportedOperationException("Unknown status " + status);
    }

    @Generated
    public BuildStatus getOldStatus() {
        return this.oldStatus;
    }

    @Generated
    public Build getBuild() {
        return this.build;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildChangedNotification)) {
            return false;
        }
        BuildChangedNotification other = (BuildChangedNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BuildStatus this$oldStatus = this.getOldStatus();
        BuildStatus other$oldStatus = other.getOldStatus();
        if (this$oldStatus == null ? other$oldStatus != null : !this$oldStatus.equals(other$oldStatus)) {
            return false;
        }
        Build this$build = this.getBuild();
        Build other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !((Object)this$build).equals(other$build));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildChangedNotification;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuildStatus $oldStatus = this.getOldStatus();
        result = result * 59 + ($oldStatus == null ? 43 : $oldStatus.hashCode());
        Build $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BuildChangedNotification(oldStatus=" + this.getOldStatus() + ", build=" + this.getBuild() + ")";
    }
}

