package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.String;
import java.util.Map;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.Project;

public class ProjectPatchBuilder extends PatchBase<ProjectPatchBuilder, Project> {
  public ProjectPatchBuilder() {
    super(org.jboss.pnc.dto.Project.class);
  }

  public ProjectPatchBuilder addBuildConfigs(Map<String, BuildConfigurationRef> elements) throws
      PatchBuilderException {
    try {
      return add(elements, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProjectPatchBuilder replaceBuildConfigs(Map<String, BuildConfigurationRef> element) throws
      PatchBuilderException {
    try {
      return replace(element, "buildConfigs");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProjectPatchBuilder replaceName(String element) throws PatchBuilderException {
    try {
      return replace(element, "name");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProjectPatchBuilder replaceDescription(String element) throws PatchBuilderException {
    try {
      return replace(element, "description");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProjectPatchBuilder replaceIssueTrackerUrl(String element) throws PatchBuilderException {
    try {
      return replace(element, "issueTrackerUrl");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProjectPatchBuilder replaceProjectUrl(String element) throws PatchBuilderException {
    try {
      return replace(element, "projectUrl");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProjectPatchBuilder replaceEngineeringTeam(String element) throws PatchBuilderException {
    try {
      return replace(element, "engineeringTeam");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProjectPatchBuilder replaceTechnicalLeader(String element) throws PatchBuilderException {
    try {
      return replace(element, "technicalLeader");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
