/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import lombok.Generated;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.validation.constraints.RefHasId;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductMilestone
extends ProductMilestoneRef {
    @RefHasId(groups={WhenCreatingNew.class})
    private final ProductVersionRef productVersion;
    private final ProductReleaseRef productRelease;
    @Deprecated
    private final User distributedArtifactsImporter;
    private final User deliveredArtifactsImporter;

    private ProductMilestone(ProductVersionRef productVersion, ProductReleaseRef productRelease, User distributedArtifactsImporter, User deliveredArtifactsImporter, String id, String version, Instant endDate, Instant startingDate, Instant plannedEndDate) {
        super(id, version, endDate, startingDate, plannedEndDate);
        this.productVersion = productVersion;
        this.productRelease = productRelease;
        this.distributedArtifactsImporter = distributedArtifactsImporter;
        this.deliveredArtifactsImporter = deliveredArtifactsImporter;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().productVersion(this.productVersion).productRelease(this.productRelease).distributedArtifactsImporter(this.distributedArtifactsImporter).deliveredArtifactsImporter(this.deliveredArtifactsImporter).id(this.id).version(this.version).endDate(this.endDate).startingDate(this.startingDate).plannedEndDate(this.plannedEndDate);
    }

    @Generated
    public ProductVersionRef getProductVersion() {
        return this.productVersion;
    }

    @Generated
    public ProductReleaseRef getProductRelease() {
        return this.productRelease;
    }

    @Deprecated
    @Generated
    public User getDistributedArtifactsImporter() {
        return this.distributedArtifactsImporter;
    }

    @Generated
    public User getDeliveredArtifactsImporter() {
        return this.deliveredArtifactsImporter;
    }

    @Override
    @Generated
    public String toString() {
        return "ProductMilestone(super=" + super.toString() + ", productVersion=" + this.getProductVersion() + ", productRelease=" + this.getProductRelease() + ", distributedArtifactsImporter=" + this.getDistributedArtifactsImporter() + ", deliveredArtifactsImporter=" + this.getDeliveredArtifactsImporter() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductMilestone)) {
            return false;
        }
        ProductMilestone other = (ProductMilestone)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProductVersionRef this$productVersion = this.getProductVersion();
        ProductVersionRef other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !((Object)this$productVersion).equals(other$productVersion)) {
            return false;
        }
        ProductReleaseRef this$productRelease = this.getProductRelease();
        ProductReleaseRef other$productRelease = other.getProductRelease();
        if (this$productRelease == null ? other$productRelease != null : !((Object)this$productRelease).equals(other$productRelease)) {
            return false;
        }
        User this$distributedArtifactsImporter = this.getDistributedArtifactsImporter();
        User other$distributedArtifactsImporter = other.getDistributedArtifactsImporter();
        if (this$distributedArtifactsImporter == null ? other$distributedArtifactsImporter != null : !((Object)this$distributedArtifactsImporter).equals(other$distributedArtifactsImporter)) {
            return false;
        }
        User this$deliveredArtifactsImporter = this.getDeliveredArtifactsImporter();
        User other$deliveredArtifactsImporter = other.getDeliveredArtifactsImporter();
        return !(this$deliveredArtifactsImporter == null ? other$deliveredArtifactsImporter != null : !((Object)this$deliveredArtifactsImporter).equals(other$deliveredArtifactsImporter));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProductMilestone;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProductVersionRef $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : ((Object)$productVersion).hashCode());
        ProductReleaseRef $productRelease = this.getProductRelease();
        result = result * 59 + ($productRelease == null ? 43 : ((Object)$productRelease).hashCode());
        User $distributedArtifactsImporter = this.getDistributedArtifactsImporter();
        result = result * 59 + ($distributedArtifactsImporter == null ? 43 : ((Object)$distributedArtifactsImporter).hashCode());
        User $deliveredArtifactsImporter = this.getDeliveredArtifactsImporter();
        result = result * 59 + ($deliveredArtifactsImporter == null ? 43 : ((Object)$deliveredArtifactsImporter).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        @Generated
        private ProductVersionRef productVersion;
        @Generated
        private ProductReleaseRef productRelease;
        @Generated
        private User distributedArtifactsImporter;
        @Generated
        private User deliveredArtifactsImporter;
        @Generated
        private String id;
        @Generated
        private String version;
        @Generated
        private Instant endDate;
        @Generated
        private Instant startingDate;
        @Generated
        private Instant plannedEndDate;

        @Generated
        Builder() {
        }

        @Generated
        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        @Generated
        public Builder productRelease(ProductReleaseRef productRelease) {
            this.productRelease = productRelease;
            return this;
        }

        @Generated
        public Builder distributedArtifactsImporter(User distributedArtifactsImporter) {
            this.distributedArtifactsImporter = distributedArtifactsImporter;
            return this;
        }

        @Generated
        public Builder deliveredArtifactsImporter(User deliveredArtifactsImporter) {
            this.deliveredArtifactsImporter = deliveredArtifactsImporter;
            return this;
        }

        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        @Generated
        public Builder startingDate(Instant startingDate) {
            this.startingDate = startingDate;
            return this;
        }

        @Generated
        public Builder plannedEndDate(Instant plannedEndDate) {
            this.plannedEndDate = plannedEndDate;
            return this;
        }

        @Generated
        public ProductMilestone build() {
            return new ProductMilestone(this.productVersion, this.productRelease, this.distributedArtifactsImporter, this.deliveredArtifactsImporter, this.id, this.version, this.endDate, this.startingDate, this.plannedEndDate);
        }

        @Generated
        public String toString() {
            return "ProductMilestone.Builder(productVersion=" + this.productVersion + ", productRelease=" + this.productRelease + ", distributedArtifactsImporter=" + this.distributedArtifactsImporter + ", deliveredArtifactsImporter=" + this.deliveredArtifactsImporter + ", id=" + this.id + ", version=" + this.version + ", endDate=" + this.endDate + ", startingDate=" + this.startingDate + ", plannedEndDate=" + this.plannedEndDate + ")";
        }
    }
}

