/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.notification.Notification;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.enums.JobNotificationProgress;
import org.jboss.pnc.enums.JobNotificationType;

public class GroupBuildChangedNotification
extends Notification {
    private static final String GROUP_BUILD_STATUS_CHANGED = "GROUP_BUILD_STATUS_CHANGED";
    private final GroupBuild groupBuild;

    @JsonCreator
    public GroupBuildChangedNotification(@JsonProperty(value="groupBuild") GroupBuild groupBuild) {
        super(JobNotificationType.GROUP_BUILD, GROUP_BUILD_STATUS_CHANGED, GroupBuildChangedNotification.getProgress(groupBuild.getStatus()), GroupBuildChangedNotification.getPreviousProgress(groupBuild.getStatus()));
        this.groupBuild = groupBuild;
    }

    public GroupBuildChangedNotification(GroupBuild groupBuild, BuildStatus oldStatus) {
        super(JobNotificationType.GROUP_BUILD, GROUP_BUILD_STATUS_CHANGED, GroupBuildChangedNotification.getProgress(groupBuild.getStatus()), oldStatus == null ? JobNotificationProgress.PENDING : GroupBuildChangedNotification.getProgress(oldStatus));
        this.groupBuild = groupBuild;
    }

    public static JobNotificationProgress getProgress(BuildStatus status) {
        if (BuildStatus.NEW.equals((Object)status)) {
            return JobNotificationProgress.PENDING;
        }
        if (status.isFinal()) {
            return JobNotificationProgress.FINISHED;
        }
        return JobNotificationProgress.IN_PROGRESS;
    }

    public static JobNotificationProgress getPreviousProgress(BuildStatus status) {
        if (BuildStatus.NEW.equals((Object)status)) {
            return null;
        }
        if (BuildStatus.NO_REBUILD_REQUIRED.equals((Object)status)) {
            return JobNotificationProgress.PENDING;
        }
        if (status.isFinal()) {
            return JobNotificationProgress.IN_PROGRESS;
        }
        return JobNotificationProgress.PENDING;
    }

    @Generated
    public GroupBuild getGroupBuild() {
        return this.groupBuild;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupBuildChangedNotification)) {
            return false;
        }
        GroupBuildChangedNotification other = (GroupBuildChangedNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GroupBuild this$groupBuild = this.getGroupBuild();
        GroupBuild other$groupBuild = other.getGroupBuild();
        return !(this$groupBuild == null ? other$groupBuild != null : !((Object)this$groupBuild).equals(other$groupBuild));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupBuildChangedNotification;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GroupBuild $groupBuild = this.getGroupBuild();
        result = result * 59 + ($groupBuild == null ? 43 : ((Object)$groupBuild).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GroupBuildChangedNotification(groupBuild=" + this.getGroupBuild() + ")";
    }
}

