/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.executor;

import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.bpm.notification.BpmNotifier;
import org.jboss.pnc.common.Date.ExpiresDate;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.common.logging.BuildTaskContext;
import org.jboss.pnc.spi.events.BuildExecutionStatusChangedEvent;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.spi.executor.BuildExecutor;
import org.jboss.pnc.spi.executor.exceptions.ExecutorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BuildExecutorTriggerer {
    private static final Logger log = LoggerFactory.getLogger(BuildExecutorTriggerer.class);
    private BuildExecutor buildExecutor;
    private BpmNotifier bpmNotifier;
    private SystemConfig systemConfig;

    @Deprecated
    public BuildExecutorTriggerer() {
    }

    @Inject
    public BuildExecutorTriggerer(BuildExecutor buildExecutor, BpmNotifier bpmNotifier, SystemConfig systemConfig) {
        this.buildExecutor = buildExecutor;
        this.bpmNotifier = bpmNotifier;
        this.systemConfig = systemConfig;
    }

    public BuildExecutionSession executeBuild(BuildExecutionConfiguration buildExecutionConfig, String callbackUrl, String accessToken) throws CoreException, ExecutorException {
        Consumer<BuildExecutionStatusChangedEvent> onExecutionStatusChange = statusChangedEvent -> {
            log.debug("Received BuildExecutionStatusChangedEvent: " + statusChangedEvent);
            if (statusChangedEvent.isFinal() && callbackUrl != null && !callbackUrl.isEmpty()) {
                statusChangedEvent.getBuildResult().ifPresent(buildResult -> this.bpmNotifier.sendBuildExecutionCompleted(callbackUrl, buildResult));
            }
        };
        BuildExecutionSession buildExecutionSession = this.buildExecutor.startBuilding(buildExecutionConfig, onExecutionStatusChange, accessToken);
        return buildExecutionSession;
    }

    public void cancelBuild(Integer buildExecutionConfigId) throws CoreException, ExecutorException {
        this.buildExecutor.cancel(buildExecutionConfigId);
    }

    public Optional<BuildTaskContext> getMdcMeta(Integer buildExecutionConfigId, String userId) {
        BuildExecutionSession runningExecution = this.buildExecutor.getRunningExecution(buildExecutionConfigId.intValue());
        if (runningExecution != null) {
            BuildExecutionConfiguration buildExecutionConfiguration = runningExecution.getBuildExecutionConfiguration();
            boolean temporaryBuild = buildExecutionConfiguration.isTempBuild();
            return Optional.of(new BuildTaskContext(buildExecutionConfiguration.getBuildContentId(), userId, temporaryBuild, ExpiresDate.getTemporaryBuildExpireDate((long)this.systemConfig.getTemporaryBuildsLifeSpan(), (boolean)temporaryBuild)));
        }
        return Optional.empty();
    }
}

