/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.time.Instant;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.dto.ArtifactRef;
import org.jboss.pnc.dto.ArtifactRevision;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.ArtifactProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.mapper.api.ArtifactRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.ArtifactAudited;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.TargetRepositoryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ArtifactProviderImpl
extends AbstractProvider<Integer, Artifact, org.jboss.pnc.dto.Artifact, ArtifactRef>
implements ArtifactProvider {
    private static Logger logger = LoggerFactory.getLogger(ArtifactProviderImpl.class);
    private static final EnumSet<ArtifactQuality> USER_ALLOWED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.NEW, ArtifactQuality.VERIFIED, ArtifactQuality.TESTED, ArtifactQuality.DEPRECATED);
    private static final EnumSet<ArtifactQuality> ADMIN_ALLOWED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.NEW, new ArtifactQuality[]{ArtifactQuality.VERIFIED, ArtifactQuality.TESTED, ArtifactQuality.DEPRECATED, ArtifactQuality.BLACKLISTED, ArtifactQuality.DELETED});
    private static final EnumSet<ArtifactQuality> NOT_MODIFIABLE_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.DELETED, ArtifactQuality.BLACKLISTED);
    private BuildRecordRepository buildRecordRepository;
    private final TargetRepositoryRepository targetRepositoryRepository;
    private ArtifactRevisionMapper artifactRevisionMapper;
    private ArtifactAuditedRepository artifactAuditedRepository;
    private UserService userService;
    private UserMapper userMapper;

    @Inject
    public ArtifactProviderImpl(ArtifactRepository repository, ArtifactMapper mapper, ArtifactRevisionMapper artifactRevisionMapper, BuildRecordRepository buildRecordRepository, TargetRepositoryRepository targetRepositoryRepository, ArtifactAuditedRepository artifactAuditedRepository, UserService userService, UserMapper userMapper) {
        super(repository, mapper, Artifact.class);
        this.buildRecordRepository = buildRecordRepository;
        this.targetRepositoryRepository = targetRepositoryRepository;
        this.artifactRevisionMapper = artifactRevisionMapper;
        this.artifactAuditedRepository = artifactAuditedRepository;
        this.userService = userService;
        this.userMapper = userMapper;
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getAll(int pageIndex, int pageSize, String sortingRsql, String query, Optional<String> sha256, Optional<String> md5, Optional<String> sha1) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withSha256(sha256), ArtifactPredicates.withMd5(md5), ArtifactPredicates.withSha1(sha1));
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public org.jboss.pnc.dto.Artifact store(org.jboss.pnc.dto.Artifact restEntity) throws DTOValidationException {
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        Instant now = Instant.now();
        return super.store(restEntity.toBuilder().creationUser(user).modificationUser(user).creationTime(now).modificationTime(now).build());
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public org.jboss.pnc.dto.Artifact update(String id, org.jboss.pnc.dto.Artifact restEntity) throws DTOValidationException {
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        Instant now = Instant.now();
        return super.update(id, restEntity.toBuilder().modificationUser(user).modificationTime(now).build());
    }

    @Override
    public ArtifactRevision createQualityLevelRevision(String id, String quality, String reason) throws DTOValidationException {
        boolean isLoggedInUserSystemUser = this.userService.hasLoggedInUserRole("system-user");
        ArtifactQuality newQuality = this.validateProvidedArtifactQuality(quality, isLoggedInUserSystemUser);
        org.jboss.pnc.dto.Artifact artifact = (org.jboss.pnc.dto.Artifact)this.getSpecific(id);
        if (artifact == null) {
            throw new InvalidEntityException("Artifact with id: " + id + " does not exist.");
        }
        this.validateIfArtifactQualityIsModifiable(artifact, newQuality);
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        Instant now = Instant.now();
        super.update(id, artifact.toBuilder().modificationUser(user).modificationTime(now).artifactQuality(newQuality).qualityLevelReason(reason).build());
        ArtifactAudited latestRevision = this.artifactAuditedRepository.findLatestById(Integer.parseInt(id));
        if (latestRevision == null) {
            throw new RepositoryViolationException("Entity should exist in the DB");
        }
        return this.artifactRevisionMapper.toDTO(latestRevision);
    }

    @Override
    @DenyAll
    public void delete(String id) throws DTOValidationException {
        throw new UnsupportedOperationException("Direct artifact manipulation is not available.");
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getBuiltArtifactsForBuild(int pageIndex, int pageSize, String sortingRsql, String query, String buildId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withBuildRecordId((Integer)((Integer)BuildMapper.idMapper.toEntity((Object)buildId))));
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getDependantArtifactsForBuild(int pageIndex, int pageSize, String sortingRsql, String query, String buildId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withDependantBuildRecordId((Integer)((Integer)BuildMapper.idMapper.toEntity((Object)buildId))));
    }

    @Override
    public Page<ArtifactRevision> getRevisions(int pageIndex, int pageSize, String id) {
        List auditedBuildConfigs = this.artifactAuditedRepository.findAllByIdOrderByRevDesc(Integer.valueOf(id));
        List toReturn = StreamHelper.nullableStreamOf((Collection)auditedBuildConfigs).map(arg_0 -> ((ArtifactRevisionMapper)this.artifactRevisionMapper).toDTO(arg_0)).skip(pageIndex * pageSize).limit(pageSize).collect(Collectors.toList());
        int totalHits = auditedBuildConfigs.size();
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        return new Page(pageIndex, pageSize, totalPages, totalHits, toReturn);
    }

    @Override
    public ArtifactRevision getRevision(String id, Integer rev) {
        IdRev idRev = new IdRev(Integer.valueOf(id), rev);
        ArtifactAudited auditedArtifact = this.artifactAuditedRepository.queryById(idRev);
        return this.artifactRevisionMapper.toDTO(auditedArtifact);
    }

    private ArtifactQuality validateProvidedArtifactQuality(String quality, boolean isLoggedInUserSystemUser) {
        EnumSet<ArtifactQuality> allowedQualities;
        ArtifactQuality newQuality;
        try {
            newQuality = ArtifactQuality.valueOf((String)quality.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidEntityException("Artifact quality: " + quality + " does not exist.");
        }
        EnumSet<ArtifactQuality> enumSet = allowedQualities = isLoggedInUserSystemUser ? ADMIN_ALLOWED_ARTIFACT_QUALITIES : USER_ALLOWED_ARTIFACT_QUALITIES;
        if (!allowedQualities.contains(newQuality)) {
            throw new InvalidEntityException("Artifact quality level can be changed only to " + allowedQualities);
        }
        return newQuality;
    }

    private void validateIfArtifactQualityIsModifiable(org.jboss.pnc.dto.Artifact artifact, ArtifactQuality newQuality) {
        if (NOT_MODIFIABLE_ARTIFACT_QUALITIES.contains(artifact.getArtifactQuality())) {
            throw new ConflictedEntryException("Artifact " + artifact.getId() + " with quality " + artifact.getArtifactQuality() + " cannot be changed to another quality level.", Artifact.class, artifact.getId().toString());
        }
        if (ArtifactQuality.TEMPORARY.equals((Object)artifact.getArtifactQuality()) && !newQuality.equals((Object)ArtifactQuality.DELETED)) {
            throw new ConflictedEntryException("Temporary artifact " + artifact.getId() + " can only be changed to DELETED quality level.", Artifact.class, artifact.getId().toString());
        }
    }
}

