/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJBAccessException;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.gerrit.Gerrit;
import org.jboss.pnc.common.gerrit.GerritException;
import org.jboss.pnc.common.graph.GraphBuilder;
import org.jboss.pnc.common.graph.GraphUtils;
import org.jboss.pnc.common.util.HttpUtils;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.coordinator.maintenance.TemporaryBuildsCleanerAsyncInvoker;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RunningBuildCount;
import org.jboss.pnc.dto.response.SSHCredentials;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.BuildPageInfo;
import org.jboss.pnc.facade.providers.api.BuildProvider;
import org.jboss.pnc.facade.util.GraphDtoBuilder;
import org.jboss.pnc.facade.util.MergeIterator;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.CorruptedDataException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.EntityMapper;
import org.jboss.pnc.mapper.api.ResultMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.coordinator.Result;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigurationPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildRecordPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.SortInfoProducer;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultPageInfo;
import org.jboss.pnc.spi.exception.ValidationException;
import org.jboss.util.graph.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class BuildProviderImpl
extends AbstractProvider<Integer, BuildRecord, Build, BuildRef>
implements BuildProvider {
    private static final Logger logger = LoggerFactory.getLogger(BuildProviderImpl.class);
    private ArtifactRepository artifactRepository;
    private BuildRecordRepository buildRecordRepository;
    private BuildConfigurationRepository buildConfigurationRepository;
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    private BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    private Gerrit gerrit;
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;
    private BuildMapper buildMapper;
    private BuildCoordinator buildCoordinator;
    private SortInfoProducer sortInfoProducer;
    private UserService userService;
    private TemporaryBuildsCleanerAsyncInvoker temporaryBuildsCleanerAsyncInvoker;
    private ResultMapper resultMapper;

    @Inject
    public BuildProviderImpl(ArtifactRepository artifactRepository, BuildRecordRepository repository, BuildMapper mapper, BuildConfigurationRepository buildConfigurationRepository, BuildConfigurationAuditedRepository buildConfigurationAuditedRepository, BuildConfigSetRecordRepository buildConfigSetRecordRepository, Gerrit gerrit, BuildConfigurationRevisionMapper buildConfigurationRevisionMapper, BuildCoordinator buildCoordinator, SortInfoProducer sortInfoProducer, UserService userService, TemporaryBuildsCleanerAsyncInvoker temporaryBuildsCleanerAsyncInvoker, ResultMapper resultMapper) {
        super(repository, mapper, BuildRecord.class);
        this.artifactRepository = artifactRepository;
        this.buildRecordRepository = repository;
        this.buildConfigurationRepository = buildConfigurationRepository;
        this.buildConfigurationAuditedRepository = buildConfigurationAuditedRepository;
        this.buildConfigSetRecordRepository = buildConfigSetRecordRepository;
        this.gerrit = gerrit;
        this.buildConfigurationRevisionMapper = buildConfigurationRevisionMapper;
        this.buildMapper = mapper;
        this.buildCoordinator = buildCoordinator;
        this.sortInfoProducer = sortInfoProducer;
        this.userService = userService;
        this.temporaryBuildsCleanerAsyncInvoker = temporaryBuildsCleanerAsyncInvoker;
        this.resultMapper = resultMapper;
    }

    @Override
    public Build store(Build restEntity) throws DTOValidationException {
        throw new UnsupportedOperationException("Direct build creation is not available.");
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting persistent builds is never allowed");
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public Build update(String id, Build restEntity) {
        return super.update(id, restEntity);
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public boolean delete(String buildId, String callback) {
        User user = this.userService.currentUser();
        if (user == null) {
            throw new RuntimeException("Failed to load user metadata.");
        }
        try {
            return this.temporaryBuildsCleanerAsyncInvoker.deleteTemporaryBuild((Integer)BuildMapper.idMapper.toEntity((Object)buildId), user.getLoginToken(), this.notifyOnBuildDeletionCompletion(callback));
        }
        catch (ValidationException e) {
            throw new RepositoryViolationException(e);
        }
    }

    private Consumer<Result> notifyOnBuildDeletionCompletion(String callback) {
        return result -> {
            if (callback != null && !callback.isEmpty()) {
                try {
                    HttpUtils.performHttpPostRequest((String)callback, (Object)this.resultMapper.toDTO(result));
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to perform a callback of delete operation.", (Throwable)e);
                }
            }
        };
    }

    @Override
    public Page<Build> getAllIndependentTemporaryOlderThanTimestamp(int pageIndex, int pageSize, String sort, String q, long timestamp) {
        return this.queryForCollection(pageIndex, pageSize, sort, q, BuildRecordPredicates.temporaryBuild(), BuildRecordPredicates.buildFinishedBefore((Date)new Date(timestamp)), BuildRecordPredicates.withoutImplicitDependants());
    }

    @Override
    public void addAttribute(String buildId, String key, String value) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        if (null == key) {
            throw new IllegalArgumentException("Attribute key must not be null");
        }
        if (!key.matches("[a-zA-Z_0-9]+")) {
            throw new IllegalArgumentException("Attribute key must match [a-zA-Z_0-9]+");
        }
        switch (key) {
            case "BREW_BUILD_NAME": {
                buildRecord.setExecutionRootName(value);
                break;
            }
            case "BREW_BUILD_VERSION": {
                buildRecord.setExecutionRootVersion(value);
                break;
            }
            default: {
                buildRecord.putAttribute(key, value);
            }
        }
        this.repository.save((GenericEntity)buildRecord);
    }

    @Override
    public void removeAttribute(String buildId, String key) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        switch (key) {
            case "BREW_BUILD_NAME": {
                buildRecord.setExecutionRootName(null);
                break;
            }
            case "BREW_BUILD_VERSION": {
                buildRecord.setExecutionRootVersion(null);
                break;
            }
            default: {
                buildRecord.removeAttribute(key);
            }
        }
        this.repository.save((GenericEntity)buildRecord);
    }

    @Override
    public BuildConfigurationRevision getBuildConfigurationRevision(String buildId) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        if (buildRecord.getBuildConfigurationAudited() != null) {
            return this.buildConfigurationRevisionMapper.toDTO(buildRecord.getBuildConfigurationAudited());
        }
        BuildConfigurationAudited buildConfigurationAudited = this.buildConfigurationAuditedRepository.queryById(new IdRev(buildRecord.getBuildConfigurationId(), buildRecord.getBuildConfigurationRev()));
        return this.buildConfigurationRevisionMapper.toDTO(buildConfigurationAudited);
    }

    @Override
    public String getRepourLog(String buildId) {
        return this.getBuildRecord(buildId).getRepourLog();
    }

    @Override
    public String getBuildLog(String buildId) {
        return this.getBuildRecord(buildId).getBuildLog();
    }

    @Override
    public SSHCredentials getSshCredentials(String buildId) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        User user = null;
        try {
            user = this.userService.currentUser();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (!buildRecord.getUser().equals((Object)user)) {
            throw new EJBAccessException("Only user who executed the build is allowed to get the SSH credentials");
        }
        return SSHCredentials.builder().command(buildRecord.getSshCommand()).password(buildRecord.getSshPassword()).build();
    }

    @Override
    public Page<Build> getAll(int pageIndex, int pageSize, String sort, String query) {
        BuildPageInfo pageInfo = new BuildPageInfo(pageIndex, pageSize, sort, query, false, false, "");
        return this.getBuilds(pageInfo);
    }

    @Override
    public Page<Build> getBuilds(BuildPageInfo pageInfo) {
        return this.getBuildList(pageInfo, _t -> true, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)((org.jboss.pnc.spi.datastore.repositories.api.Predicate)(_r, _q, cb) -> cb.conjunction()));
    }

    @Override
    public Page<Build> getBuildsForMilestone(BuildPageInfo pageInfo, String milestoneId) {
        Predicate<BuildTask> predicate = t -> t.getProductMilestone() != null && Integer.valueOf(milestoneId).equals(t.getProductMilestone().getId());
        return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withPerformedInMilestone((Integer)Integer.valueOf(milestoneId)));
    }

    @Override
    public Page<Build> getBuildsForProject(BuildPageInfo pageInfo, String projectId) {
        Set buildConfigIds = this.buildConfigurationRepository.queryWithPredicates(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{BuildConfigurationPredicates.withProjectId((Integer)Integer.valueOf(projectId))}).stream().map(BuildConfiguration::getId).collect(Collectors.toSet());
        Predicate<BuildTask> predicate = t -> Integer.valueOf(projectId).equals(t.getBuildConfigurationAudited().getProject().getId());
        return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigurationIds(buildConfigIds));
    }

    @Override
    public Page<Build> getBuildsForArtifact(int pageIndex, int pageSize, String sortingRsql, String query, String artifactId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildRecordPredicates.withArtifactProduced((Integer)Integer.valueOf(artifactId)));
    }

    @Override
    public Page<Build> getDependantBuildsForArtifact(int pageIndex, int pageSize, String sortingRsql, String query, String artifactId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildRecordPredicates.withArtifactDependency((Integer)Integer.valueOf(artifactId)));
    }

    @Override
    public Page<Build> getBuildsForBuildConfiguration(BuildPageInfo pageInfo, String buildConfigurationId) {
        Predicate<BuildTask> predicate = t -> Integer.valueOf(buildConfigurationId).equals(t.getBuildConfigurationAudited().getId());
        return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigurationId((Integer)Integer.valueOf(buildConfigurationId)));
    }

    @Override
    public Page<Build> getBuildsForUser(BuildPageInfo pageInfo, String userId) {
        Predicate<BuildTask> predicate = t -> Integer.valueOf(userId).equals(t.getUser().getId());
        return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withUserId((Integer)Integer.valueOf(userId)));
    }

    @Override
    public Page<Build> getBuildsForGroupConfiguration(BuildPageInfo pageInfo, String groupConfigurationId) {
        Predicate<BuildTask> predicate = t -> t.getBuildSetTask() != null && t.getBuildSetTask().getBuildConfigSetRecord().map(gc -> Integer.valueOf(groupConfigurationId).equals(gc.getBuildConfigurationSet().getId())).orElse(false) != false;
        return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigSetId((Integer)Integer.valueOf(groupConfigurationId)));
    }

    @Override
    public Page<Build> getBuildsForGroupBuild(BuildPageInfo pageInfo, String groupBuildId) {
        Predicate<BuildTask> predicate = t -> t.getBuildSetTask() != null && t.getBuildSetTask().getBuildConfigSetRecord().map(gc -> Integer.valueOf(groupBuildId).equals(gc.getId())).orElse(false) != false;
        return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigSetRecordId((Integer)Integer.valueOf(groupBuildId)));
    }

    @Override
    public Graph<Build> getBuildGraphForGroupBuild(String groupBuildId) {
        BuildConfigSetRecord buildConfigSetRecord = (BuildConfigSetRecord)this.buildConfigSetRecordRepository.queryById((Serializable)Integer.valueOf(groupBuildId));
        if (buildConfigSetRecord == null) {
            throw new EmptyEntityException("Build group " + groupBuildId + " does not exists.");
        }
        List<String> runningAndStoredIds = this.getBuildIdsInTheGroup(buildConfigSetRecord);
        org.jboss.util.graph.Graph buildGraph = new org.jboss.util.graph.Graph();
        for (String buildId : runningAndStoredIds) {
            org.jboss.util.graph.Graph<BuildWithDependencies> dependencyGraph = this.createBuildDependencyGraph(buildId);
            GraphUtils.merge((org.jboss.util.graph.Graph)buildGraph, dependencyGraph);
            logger.trace("Merged graph from buildRecordId {} to BuildConfigSetRecordGraph {}; Edges {},", new Object[]{buildId, buildGraph, buildGraph.getEdges()});
        }
        GraphDtoBuilder graphBuilder = new GraphDtoBuilder();
        Graph<Build> graphDto = graphBuilder.from(buildGraph, Build.class, vertex -> ((BuildWithDependencies)vertex.getData()).getBuild());
        return graphDto;
    }

    private List<String> getBuildIdsInTheGroup(BuildConfigSetRecord buildConfigSetRecord) {
        List runningTaskIds = StreamHelper.nullableStreamOf((Collection)this.buildCoordinator.getSubmittedBuildTasks()).filter(Objects::nonNull).filter(t -> t.getBuildSetTask() != null && buildConfigSetRecord.getId().equals(t.getBuildSetTask().getId())).sorted(Comparator.comparingInt(BuildTask::getId)).map(t -> Integer.toString(t.getId())).collect(Collectors.toList());
        ArrayList<String> runningAndStoredIds = new ArrayList<String>(runningTaskIds);
        Set storedBuildIds = buildConfigSetRecord.getBuildRecords().stream().map(br -> Integer.toString(br.getId())).collect(Collectors.toSet());
        runningAndStoredIds.addAll(storedBuildIds);
        return runningAndStoredIds;
    }

    @Override
    public Graph<Build> getDependencyGraph(String buildId) {
        Build specific = this.getSpecific(buildId);
        if (specific == null) {
            throw new EmptyEntityException("there is no record for given buildId.");
        }
        org.jboss.util.graph.Graph<BuildWithDependencies> buildGraph = this.createBuildDependencyGraph(buildId);
        GraphDtoBuilder<BuildWithDependencies, Build> graphBuilder = new GraphDtoBuilder<BuildWithDependencies, Build>();
        return graphBuilder.from(buildGraph, Build.class, vertex -> ((BuildWithDependencies)vertex.getData()).getBuild());
    }

    private org.jboss.util.graph.Graph<BuildWithDependencies> createBuildDependencyGraph(String buildId) {
        GraphBuilder graphBuilder = new GraphBuilder(id -> this.getRunningOrCompletedBuild((String)id), bt -> bt.getDependencies(), bt -> bt.getDependants());
        org.jboss.util.graph.Graph graph = new org.jboss.util.graph.Graph();
        Vertex current = graphBuilder.buildDependencyGraph(graph, (Object)buildId);
        if (current != null) {
            BuildWithDependencies currentTask = (BuildWithDependencies)current.getData();
            graphBuilder.buildDependentGraph(graph, (Object)currentTask.getBuild().getId());
        }
        return graph;
    }

    @Override
    public URI getInternalScmArchiveLink(String buildId) {
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)((Integer)BuildMapper.idMapper.toEntity((Object)buildId)));
        if (buildRecord.getScmRevision() == null) {
            return null;
        }
        try {
            return new URI(this.gerrit.generateDownloadUrlWithGerritGitweb(buildRecord.getScmRepoURL(), buildRecord.getScmRevision()));
        }
        catch (URISyntaxException | GerritException e) {
            throw new RepositoryViolationException(e);
        }
    }

    private BuildRecord getBuildRecord(String buildId) {
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)((Integer)BuildMapper.idMapper.toEntity((Object)buildId)));
        if (buildRecord == null) {
            throw new EmptyEntityException("Build with id: " + buildId + " does not exist!");
        }
        return buildRecord;
    }

    private BuildWithDependencies getRunningOrCompletedBuild(String id) {
        Optional<BuildTask> buildTask = this.buildCoordinator.getSubmittedBuildTasks().stream().filter(submittedBuild -> Integer.toString(submittedBuild.getId()).equals(id)).findFirst();
        if (buildTask.isPresent()) {
            return new BuildWithDependencies(buildTask.get());
        }
        BuildRecord buildRecord = this.buildRecordRepository.findByIdFetchProperties(Integer.valueOf(Integer.parseInt(id)));
        if (buildRecord == null) {
            throw new CorruptedDataException("Missing build with id:" + id);
        }
        return new BuildWithDependencies(buildRecord);
    }

    @Override
    public Build getSpecific(String buildId) {
        List runningBuilds = this.buildCoordinator.getSubmittedBuildTasks();
        Build build = runningBuilds.stream().filter(buildTask -> buildId.equals(BuildMapper.idMapper.toDto((Object)buildTask.getId()))).findAny().map(arg_0 -> ((BuildMapper)this.buildMapper).fromBuildTask(arg_0)).orElse(null);
        if (build == null) {
            build = (Build)this.mapper.toDTO((GenericEntity)this.buildRecordRepository.findByIdFetchProperties((Integer)BuildMapper.idMapper.toEntity((Object)buildId)));
        }
        return build;
    }

    @Override
    public Page<Build> getAllByStatusAndLogContaining(int pageIndex, int pageSize, String sortingRsql, String query, BuildStatus status, String search) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildRecordPredicates.withStatus((BuildStatus)status), BuildRecordPredicates.withBuildLogContains((String)search));
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public void setBuiltArtifacts(String buildId, List<String> artifactIds) {
        Set ids = artifactIds.stream().map(Integer::valueOf).collect(Collectors.toSet());
        List artifacts = this.artifactRepository.queryWithPredicates(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{ArtifactPredicates.withIds(ids)});
        if (ids.size() != artifacts.size()) {
            artifacts.stream().map(Artifact::getId).forEach(ids::remove);
            throw new InvalidEntityException("Artifacts not found, missing ids: " + ids);
        }
        Integer id = (Integer)BuildMapper.idMapper.toEntity((Object)buildId);
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)id);
        for (Artifact artifact : artifacts) {
            if (artifact.getBuildRecord() != null && !id.equals(artifact.getBuildRecord().getId())) {
                throw new ConflictedEntryException("Artifact " + artifact.getId() + " is already marked as built by different build.", BuildRecord.class, artifact.getBuildRecord().getId().toString());
            }
            artifact.setBuildRecord(buildRecord);
        }
        HashSet oldBuiltArtifacts = new HashSet(buildRecord.getBuiltArtifacts());
        oldBuiltArtifacts.stream().filter(a -> !ids.contains(a.getId())).forEach(a -> a.setBuildRecord(null));
    }

    @Override
    public Set<String> getBuiltArtifactIds(String buildId) {
        Integer id = (Integer)BuildMapper.idMapper.toEntity((Object)buildId);
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)id);
        return StreamHelper.nullableStreamOf((Collection)buildRecord.getBuiltArtifacts()).map(builtArtifact -> builtArtifact.getId().toString()).collect(Collectors.toSet());
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public void setDependentArtifacts(String buildId, List<String> artifactIds) {
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)((Integer)BuildMapper.idMapper.toEntity((Object)buildId)));
        Set artifacts = artifactIds.stream().map(aId -> Artifact.Builder.newBuilder().id(Integer.valueOf(aId)).build()).collect(Collectors.toSet());
        buildRecord.setDependencies(artifacts);
        this.repository.save((GenericEntity)buildRecord);
    }

    @Override
    public RunningBuildCount getRunningCount() {
        List x = this.buildCoordinator.getSubmittedBuildTasks();
        int waitingForDependencies = 0;
        int running = 0;
        int enqueued = 0;
        block5: for (BuildTask task : x) {
            switch (task.getStatus()) {
                case ENQUEUED: {
                    ++enqueued;
                    continue block5;
                }
                case BUILDING: {
                    ++running;
                    continue block5;
                }
                case WAITING_FOR_DEPENDENCIES: {
                    ++waitingForDependencies;
                    continue block5;
                }
            }
        }
        return new RunningBuildCount(running, enqueued, waitingForDependencies);
    }

    @Override
    public Page<Build> getByAttribute(BuildPageInfo buildPageInfo, Map<String, String> attributeConstraints) {
        HashSet<Object> predicates = new HashSet<Object>();
        for (Map.Entry<String, String> entry : attributeConstraints.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("!")) {
                predicates.add(BuildRecordPredicates.withoutAttribute((String)key.substring(1)));
                continue;
            }
            predicates.add(BuildRecordPredicates.withAttribute((String)key, (String)value));
        }
        org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> queryPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(BuildRecord.class, buildPageInfo.getQ());
        predicates.add(queryPredicate);
        org.jboss.pnc.spi.datastore.repositories.api.Predicate[] predicatesArray = predicates.toArray(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[predicates.size()]);
        DefaultPageInfo pageInfo = this.toPageInfo(buildPageInfo);
        SortInfo sortInfo = this.rsqlPredicateProducer.getSortInfo(this.type, buildPageInfo.getSort());
        List resultList = ((BuildRecordRepository)this.repository).queryWithPredicatesUsingCursor((PageInfo)pageInfo, sortInfo, predicatesArray);
        int hits = this.repository.count(predicatesArray);
        return new Page(buildPageInfo.getPageIndex(), buildPageInfo.getPageSize(), hits, (Collection)resultList.stream().map(b -> (Build)this.mapper.toDTO((GenericEntity)b)).collect(Collectors.toList()));
    }

    private DefaultPageInfo toPageInfo(BuildPageInfo buildPageInfo) {
        return new DefaultPageInfo(buildPageInfo.getPageIndex() * buildPageInfo.getPageSize(), buildPageInfo.getPageSize());
    }

    private Page<Build> getBuildList(BuildPageInfo pageInfo, Predicate<BuildTask> predicate, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate) {
        if (pageInfo.isRunning()) {
            if (pageInfo.isLatest()) {
                return this.getLatestRunningBuild(predicate);
            }
            return this.getRunningBuilds(pageInfo, predicate);
        }
        if (pageInfo.isLatest()) {
            return this.getLatestBuild(predicate, dbPredicate);
        }
        return this.getBuilds(pageInfo, predicate, dbPredicate);
    }

    private Page<Build> getLatestRunningBuild(Predicate<BuildTask> predicate) {
        List build = this.readLatestRunningBuild(predicate).map(Collections::singletonList).orElse(Collections.emptyList());
        return new Page(0, 1, build.size(), build.size(), build);
    }

    private Page<Build> getRunningBuilds(BuildPageInfo pageInfo, Predicate<BuildTask> predicate) {
        List<Build> runningBuilds = this.readRunningBuilds(pageInfo, predicate);
        List builds = runningBuilds.stream().skip(pageInfo.getPageIndex() * pageInfo.getPageSize()).limit(pageInfo.getPageSize()).collect(Collectors.toList());
        return new Page(pageInfo.getPageIndex(), pageInfo.getPageSize(), (int)Math.ceil((double)runningBuilds.size() / (double)pageInfo.getPageSize()), runningBuilds.size(), builds);
    }

    private Page<Build> getLatestBuild(Predicate<BuildTask> predicate, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate) {
        TreeSet<Build> sorted = new TreeSet<Build>(Comparator.comparing(BuildRef::getSubmitTime).reversed());
        this.readLatestRunningBuild(predicate).ifPresent(sorted::add);
        this.readLatestFinishedBuild(dbPredicate).ifPresent(sorted::add);
        if (sorted.size() > 1) {
            sorted.pollLast();
        }
        return new Page(0, 1, sorted.size(), sorted.size(), sorted);
    }

    private Page<Build> getBuilds(BuildPageInfo pageInfo, Predicate<BuildTask> predicate, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate) {
        List<Build> runningBuilds = this.readRunningBuilds(pageInfo, predicate);
        int firstPossibleDBIndex = pageInfo.getPageIndex() * pageInfo.getPageSize() - runningBuilds.size();
        int lastPossibleDBIndex = (pageInfo.getPageIndex() + 1) * pageInfo.getPageSize() - 1;
        int toSkip = Math.min(runningBuilds.size(), pageInfo.getPageIndex() * pageInfo.getPageSize());
        org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>[] predicates = this.preparePredicates(dbPredicate, pageInfo.getQ(), pageInfo.getBuildConfigName());
        Comparator<Object> comparing = Comparator.comparing(BuildRef::getSubmitTime).reversed();
        if (!StringUtils.isEmpty((String)pageInfo.getSort())) {
            comparing = this.rsqlPredicateProducer.getComparator(pageInfo.getSort());
        }
        SortInfo sortInfo = this.rsqlPredicateProducer.getSortInfo(this.type, pageInfo.getSort());
        MergeIterator<Build> builds = new MergeIterator<Build>(runningBuilds.iterator(), new BuildIterator(firstPossibleDBIndex, lastPossibleDBIndex, pageInfo.getPageSize(), sortInfo, predicates), comparing);
        List resultList = StreamSupport.stream(Spliterators.spliteratorUnknownSize(builds, 20), false).skip(toSkip).limit(pageInfo.getPageSize()).collect(Collectors.toList());
        int hits = this.repository.count(predicates) + runningBuilds.size();
        return new Page(pageInfo.getPageIndex(), pageInfo.getPageSize(), (int)Math.ceil((double)hits / (double)pageInfo.getPageSize()), hits, resultList);
    }

    private org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>[] preparePredicates(org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate, String query, String buildConfigName) {
        ArrayList<org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>> predicates = new ArrayList<org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>>(3);
        predicates.add(dbPredicate);
        if (!StringUtils.isEmpty((String)query)) {
            predicates.add(this.rsqlPredicateProducer.getCriteriaPredicate(BuildRecord.class, query));
        }
        if (!StringUtils.isEmpty((String)buildConfigName)) {
            predicates.add(this.getPredicateWithBuildConfigName(buildConfigName));
        }
        return predicates.toArray(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[0]);
    }

    private org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> getPredicateWithBuildConfigName(String buildConfigName) {
        List buildConfigurationAuditedIdRevs = this.buildConfigurationAuditedRepository.searchIdRevForBuildConfigurationName(buildConfigName);
        if (!buildConfigurationAuditedIdRevs.isEmpty()) {
            return BuildRecordPredicates.withBuildConfigurationIdRev((List)buildConfigurationAuditedIdRevs);
        }
        return org.jboss.pnc.spi.datastore.repositories.api.Predicate.nonMatching();
    }

    private List<Build> readRunningBuilds(BuildPageInfo pageInfo, Predicate<BuildTask> predicate) {
        Predicate<Object> streamPredicate = f -> true;
        if (!StringUtils.isEmpty((String)pageInfo.getQ())) {
            streamPredicate = this.rsqlPredicateProducer.getStreamPredicate(pageInfo.getQ());
        }
        Comparator<Object> comparing = Comparator.comparing(BuildRef::getSubmitTime).reversed();
        if (!StringUtils.isEmpty((String)pageInfo.getSort())) {
            comparing = this.rsqlPredicateProducer.getComparator(pageInfo.getSort());
        }
        if (!StringUtils.isEmpty((String)pageInfo.getBuildConfigName())) {
            predicate = predicate.and(t -> pageInfo.getBuildConfigName().equals(t.getBuildConfigurationAudited().getName()));
        }
        return StreamHelper.nullableStreamOf((Collection)this.buildCoordinator.getSubmittedBuildTasks()).filter(t -> t != null).filter(predicate).map(arg_0 -> ((BuildMapper)this.buildMapper).fromBuildTask(arg_0)).filter(streamPredicate).sorted(comparing).collect(Collectors.toList());
    }

    private Optional<Build> readLatestRunningBuild(Predicate<BuildTask> predicate) {
        return StreamHelper.nullableStreamOf((Collection)this.buildCoordinator.getSubmittedBuildTasks()).filter(t -> t != null).filter(predicate).sorted(Comparator.comparing(BuildTask::getSubmitTime).reversed()).findFirst().map(arg_0 -> ((BuildMapper)this.buildMapper).fromBuildTask(arg_0));
    }

    private Optional<Build> readLatestFinishedBuild(org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> predicate) {
        PageInfo pageInfo = this.pageInfoProducer.getPageInfo(0, 1);
        SortInfo sortInfo = this.sortInfoProducer.getSortInfo(SortInfo.SortingDirection.DESC, new String[]{"submitTime"});
        List buildRecords = this.repository.queryWithPredicates(pageInfo, sortInfo, new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{predicate});
        return buildRecords.stream().map(arg_0 -> ((EntityMapper)this.mapper).toDTO(arg_0)).findFirst();
    }

    private class BuildWithDependencies {
        private final Build build;
        private final Collection<String> dependencies;
        private final Collection<String> dependants;

        public BuildWithDependencies(BuildTask buildTask) {
            this.build = BuildProviderImpl.this.buildMapper.fromBuildTask(buildTask);
            this.dependencies = buildTask.getDependencies().stream().map(bt -> Integer.toString(bt.getId())).collect(Collectors.toSet());
            this.dependants = buildTask.getDependants().stream().map(bt -> Integer.toString(bt.getId())).collect(Collectors.toSet());
        }

        public BuildWithDependencies(BuildRecord buildRecord) {
            this.build = BuildProviderImpl.this.buildMapper.toDTO(buildRecord);
            this.dependencies = Arrays.stream(buildRecord.getDependencyBuildRecordIds()).map(i -> Integer.toString(i)).collect(Collectors.toSet());
            this.dependants = Arrays.stream(buildRecord.getDependentBuildRecordIds()).map(i -> Integer.toString(i)).collect(Collectors.toSet());
        }

        public Build getBuild() {
            return this.build;
        }

        public Collection<String> getDependencies() {
            return this.dependencies;
        }

        public Collection<String> getDependants() {
            return this.dependants;
        }
    }

    class BuildIterator
    implements Iterator<Build> {
        private List<BuildRecord> builds;
        private Iterator<BuildRecord> it;
        private final int maxPageSize;
        private int firstIndex;
        private final int lastIndex;
        private final SortInfo sortInfo;
        private final org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>[] predicates;

        public BuildIterator(int firstIndex, int lastIndex, int pageSize, SortInfo sortInfo, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> ... predicate) {
            this.maxPageSize = pageSize > 10 ? pageSize : 10;
            this.firstIndex = firstIndex > 0 ? firstIndex : 0;
            this.lastIndex = lastIndex;
            this.predicates = predicate;
            this.sortInfo = sortInfo;
            this.nextPage();
        }

        @Override
        public boolean hasNext() {
            if (this.it.hasNext()) {
                return true;
            }
            if (this.firstIndex > this.lastIndex) {
                return false;
            }
            this.nextPage();
            return this.it.hasNext();
        }

        @Override
        public Build next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (Build)BuildProviderImpl.this.mapper.toDTO((GenericEntity)this.it.next());
        }

        private void nextPage() {
            int size = this.lastIndex - this.firstIndex + 1;
            if (size > this.maxPageSize) {
                size = this.maxPageSize;
            }
            DefaultPageInfo pageInfo = new DefaultPageInfo(this.firstIndex, size);
            this.builds = ((BuildRecordRepository)BuildProviderImpl.this.repository).queryWithPredicatesUsingCursor((PageInfo)pageInfo, this.sortInfo, this.predicates);
            this.it = this.builds.iterator();
            this.firstIndex = this.builds.size() < size ? this.lastIndex + 1 : (this.firstIndex += size);
        }
    }
}

