/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.notification.GenericSettingNotification;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.GenericSetting;
import org.jboss.pnc.spi.datastore.repositories.GenericSettingRepository;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class GenericSettingProvider {
    private static final Logger log = LoggerFactory.getLogger(GenericSettingProvider.class);
    public static final String ANNOUNCEMENT_BANNER = "ANNOUNCEMENT_BANNER";
    public static final String MAINTENANCE_MODE = "MAINTENANCE_MODE";
    @Inject
    private GenericSettingRepository genericSettingRepository;
    @Inject
    private Notifier notifier;

    @Deprecated
    public GenericSettingProvider() {
    }

    @RolesAllowed(value={"system-user"})
    public void activateMaintenanceMode(String reason) {
        log.info("Activating Maintenance mode, with reason: '{}'", (Object)reason);
        GenericSetting maintenanceMode = this.createGenericParameterIfNotFound(MAINTENANCE_MODE);
        maintenanceMode.setValue(Boolean.TRUE.toString());
        this.genericSettingRepository.save((GenericEntity)maintenanceMode);
        this.notifier.sendMessage((Object)GenericSettingNotification.maintenanceModeChanged((boolean)true));
        this.setAnnouncementBanner(reason);
    }

    @RolesAllowed(value={"system-user"})
    public void deactivateMaintenanceMode() {
        log.info("Deactivating Maintenance mode");
        GenericSetting maintenanceMode = this.genericSettingRepository.queryByKey(MAINTENANCE_MODE);
        if (maintenanceMode != null && Boolean.parseBoolean(maintenanceMode.getValue())) {
            this.setAnnouncementBanner("");
        }
        if (maintenanceMode == null) {
            maintenanceMode = new GenericSetting();
            maintenanceMode.setKey(MAINTENANCE_MODE);
        }
        maintenanceMode.setValue(Boolean.FALSE.toString());
        this.genericSettingRepository.save((GenericEntity)maintenanceMode);
        this.notifier.sendMessage((Object)GenericSettingNotification.maintenanceModeChanged((boolean)false));
    }

    public boolean isInMaintenanceMode() {
        GenericSetting maintenanceMode = this.genericSettingRepository.queryByKey(MAINTENANCE_MODE);
        if (maintenanceMode == null) {
            return false;
        }
        return Boolean.parseBoolean(maintenanceMode.getValue());
    }

    @RolesAllowed(value={"system-user"})
    public void setAnnouncementBanner(String banner) {
        log.info("Announcement banner set to: '{}'", (Object)banner);
        GenericSetting announcementBanner = this.createGenericParameterIfNotFound(ANNOUNCEMENT_BANNER);
        announcementBanner.setValue(banner);
        this.genericSettingRepository.save((GenericEntity)announcementBanner);
        this.notifier.sendMessage((Object)GenericSettingNotification.newAnnoucement((String)banner));
    }

    public String getAnnouncementBanner() {
        GenericSetting announcementBanner = this.genericSettingRepository.queryByKey(ANNOUNCEMENT_BANNER);
        if (announcementBanner == null) {
            return "";
        }
        return announcementBanner.getValue();
    }

    private GenericSetting createGenericParameterIfNotFound(String key) {
        GenericSetting genericSetting = this.genericSettingRepository.queryByKey(key);
        if (genericSetting == null) {
            genericSetting = new GenericSetting();
            genericSetting.setKey(key);
        }
        return genericSetting;
    }
}

