/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.jboss.pnc.bpm.causeway.ProductMilestoneReleaseManager;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.ProductMilestoneCloseResult;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.response.MilestoneInfo;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.ValidationResponse;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.ValidationErrorType;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.ProductMilestoneProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.ConflictedEntryValidator;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.ProductMilestoneCloseResultMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Artifact_;
import org.jboss.pnc.model.BuildRecord_;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductMilestoneRelease;
import org.jboss.pnc.model.ProductMilestone_;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.model.ProductRelease_;
import org.jboss.pnc.model.ProductVersion_;
import org.jboss.pnc.model.Product_;
import org.jboss.pnc.spi.datastore.predicates.ProductMilestonePredicates;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ProductMilestoneProviderImpl
extends AbstractProvider<Integer, ProductMilestone, org.jboss.pnc.dto.ProductMilestone, ProductMilestoneRef>
implements ProductMilestoneProvider {
    private static final Logger log = LoggerFactory.getLogger(ProductMilestoneProviderImpl.class);
    private static final Logger userLog = LoggerFactory.getLogger((String)"org.jboss.pnc._userlog_.milestone");
    private ProductMilestoneReleaseManager releaseManager;
    private final ProductMilestoneCloseResultMapper milestoneReleaseMapper;
    @Inject
    private UserService userService;
    @Inject
    private EntityManager em;

    @Inject
    public ProductMilestoneProviderImpl(ProductMilestoneRepository repository, ProductMilestoneMapper mapper, ProductMilestoneReleaseManager releaseManager, ProductMilestoneCloseResultMapper milestoneReleaseMapper) {
        super(repository, mapper, ProductMilestone.class);
        this.releaseManager = releaseManager;
        this.milestoneReleaseMapper = milestoneReleaseMapper;
    }

    @Override
    public org.jboss.pnc.dto.ProductMilestone update(String id, org.jboss.pnc.dto.ProductMilestone restEntity) {
        this.validateBeforeUpdating(id, restEntity);
        ProductMilestone milestoneInDb = (ProductMilestone)this.repository.queryById((Serializable)Integer.valueOf(id));
        ProductMilestone milestoneRestDb = (ProductMilestone)this.mapper.toEntity((DTOEntity)restEntity);
        if (milestoneInDb.getEndDate() != null) {
            log.info("Milestone is already closed: no more modifications allowed");
            throw new RepositoryViolationException("Milestone is already closed! No more modifications allowed");
        }
        log.debug("Updating milestone for id: {}", (Object)id);
        milestoneRestDb.setId(Integer.valueOf(id));
        milestoneRestDb.setEndDate(milestoneInDb.getEndDate());
        milestoneRestDb.setProductRelease(milestoneInDb.getProductRelease());
        this.validateBeforeUpdating(id, (org.jboss.pnc.dto.ProductMilestone)this.mapper.toDTO((GenericEntity)milestoneRestDb));
        return (org.jboss.pnc.dto.ProductMilestone)this.mapper.toDTO((GenericEntity)((ProductMilestone)this.repository.save((GenericEntity)milestoneRestDb)));
    }

    @Override
    protected void validateBeforeSaving(org.jboss.pnc.dto.ProductMilestone restEntity) {
        super.validateBeforeSaving(restEntity);
        this.validateDoesNotConflict(restEntity);
    }

    @Override
    protected void validateBeforeUpdating(String id, org.jboss.pnc.dto.ProductMilestone restEntity) {
        super.validateBeforeUpdating(restEntity.getId(), restEntity);
        this.validateDoesNotConflict(restEntity);
    }

    private void validateDoesNotConflict(org.jboss.pnc.dto.ProductMilestone restEntity) throws ConflictedEntryException, InvalidEntityException {
        ValidationBuilder.validateObject(restEntity, WhenUpdating.class).validateConflict(() -> {
            ProductMilestone milestoneFromDB = (ProductMilestone)this.repository.queryByPredicates(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{ProductMilestonePredicates.withProductVersionIdAndVersion((Integer)Integer.valueOf(restEntity.getProductVersion().getId()), (String)restEntity.getVersion())});
            Integer restEntityId = null;
            if (restEntity.getId() != null) {
                restEntityId = Integer.valueOf(restEntity.getId());
            }
            if (milestoneFromDB != null && !milestoneFromDB.getId().equals(restEntityId)) {
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(milestoneFromDB.getId(), ProductMilestone.class, "Product milestone with the same product version and version already exists");
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProductMilestoneCloseResult closeMilestone(String id) {
        try {
            ProductMilestoneCloseResult closeResult;
            Long milestoneReleaseId = Sequence.nextId();
            MDCUtils.addProcessContext((String)milestoneReleaseId.toString());
            userLog.info("Processing milestone close request ...");
            ProductMilestoneCloseResult productMilestoneCloseResult = closeResult = this.doCloseMilestone(id, milestoneReleaseId);
            return productMilestoneCloseResult;
        }
        finally {
            MDCUtils.removeProcessContext();
        }
    }

    private ProductMilestoneCloseResult doCloseMilestone(String id, Long milestoneReleaseId) {
        ProductMilestone milestoneInDb = (ProductMilestone)this.repository.queryById((Serializable)Integer.valueOf(id));
        if (milestoneInDb.getEndDate() != null) {
            userLog.info("Milestone is already closed: no more modifications allowed");
            throw new RepositoryViolationException("Milestone is already closed! No more modifications allowed");
        }
        Optional inProgress = this.releaseManager.getInProgress(milestoneInDb);
        if (inProgress.isPresent()) {
            userLog.warn("Milestone close is already in progress.");
            return this.milestoneReleaseMapper.toDTO((ProductMilestoneRelease)inProgress.get());
        }
        log.debug("Milestone's 'end date' set; no release of the milestone in progress: will start release");
        ProductMilestoneRelease milestoneReleaseDb = this.releaseManager.startRelease(milestoneInDb, this.userService.currentUserToken(), milestoneReleaseId);
        ProductMilestoneCloseResult milestoneCloseResult = this.milestoneReleaseMapper.toDTO(milestoneReleaseDb);
        return milestoneCloseResult;
    }

    @Override
    public void cancelMilestoneCloseProcess(String id) throws RepositoryViolationException, EmptyEntityException {
        ProductMilestone milestoneInDb = (ProductMilestone)this.repository.queryById((Serializable)Integer.valueOf(id));
        if (milestoneInDb.getEndDate() != null) {
            userLog.info("Milestone is already closed.");
            throw new RepositoryViolationException("Milestone is already closed!");
        }
        if (this.releaseManager.noReleaseInProgress(milestoneInDb)) {
            userLog.warn("Milestone's 'end date' set and no release in progress! Cannot run cancel process for given id");
            throw new EmptyEntityException("No running cancel process for given id.");
        }
        userLog.info("Cancelling milestone release process ...");
        this.releaseManager.cancel(milestoneInDb);
    }

    @Override
    public Page<org.jboss.pnc.dto.ProductMilestone> getProductMilestonesForProductVersion(int pageIndex, int pageSize, String sortingRsql, String query, String productVersionId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ProductMilestonePredicates.withProductVersionId((Integer)Integer.valueOf(productVersionId)));
    }

    @Override
    public Page<MilestoneInfo> getMilestonesOfArtifact(String id, int pageIndex, int pageSize) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        Optional<Integer> builtIn = this.getBuildInMilestone(cb, id);
        List<Integer> dependencyOf = this.getDependentMilestoneIds(cb, id);
        HashSet<Integer> milestoneIds = new HashSet<Integer>(dependencyOf);
        builtIn.ifPresent(milestoneIds::add);
        milestoneIds.remove(null);
        if (milestoneIds.isEmpty()) {
            return new Page();
        }
        CriteriaQuery<Tuple> query = this.milestoneInfoQuery(cb, milestoneIds);
        int offset = pageIndex * pageSize;
        List milestones = this.em.createQuery(query).setMaxResults(pageSize).setFirstResult(offset).getResultList().stream().map(m -> this.mapTupleToMilestoneInfo((Tuple)m, builtIn)).collect(Collectors.toList());
        return new Page(pageIndex, pageSize, milestoneIds.size(), milestones);
    }

    @Override
    public ValidationResponse validateVersion(String productVersionId, String version) {
        boolean matches = Pattern.matches("^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$", version);
        ValidationResponse.Builder builder = ValidationResponse.builder().isValid(Boolean.valueOf(matches));
        if (!matches) {
            return builder.errorType(ValidationErrorType.FORMAT).hints(Collections.singletonList("Allowed format consists of 2 or 3 numeric components (separated by a dot) followed by a string qualifier starting with a character, eg. 3.0.0.GA, 1.0.11.CR2.ER1, 3.0.CR2")).build();
        }
        ProductMilestone duplicate = (ProductMilestone)this.repository.queryByPredicates(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{ProductMilestonePredicates.withProductVersionIdAndVersion((Integer)Integer.parseInt(productVersionId), (String)version)});
        if (duplicate != null) {
            return builder.isValid(Boolean.valueOf(false)).errorType(ValidationErrorType.DUPLICATION).hints(Collections.singletonList("Product Milestone version already exists")).build();
        }
        return builder.isValid(Boolean.valueOf(matches)).build();
    }

    private CriteriaQuery<Tuple> milestoneInfoQuery(CriteriaBuilder cb, Set<Integer> milestoneIds) {
        CriteriaQuery query = cb.createTupleQuery();
        Root milestone = query.from(ProductMilestone.class);
        Root release = query.from(ProductRelease.class);
        Path version = milestone.get(ProductMilestone_.productVersion);
        Path product = version.get(ProductVersion_.product);
        query.multiselect(new Selection[]{product.get(Product_.id), product.get(Product_.name), version.get(ProductVersion_.id), version.get(ProductVersion_.version), milestone.get(ProductMilestone_.id), milestone.get(ProductMilestone_.version), milestone.get(ProductMilestone_.endDate), release.get(ProductRelease_.id), release.get(ProductRelease_.version), release.get(ProductRelease_.releaseDate)});
        query.where(new Predicate[]{cb.and(new Predicate[]{cb.equal((Expression)release.get(ProductRelease_.productMilestone), (Expression)milestone)}), milestone.get(ProductMilestone_.id).in(milestoneIds)});
        query.orderBy(new Order[]{cb.desc((Expression)milestone.get(ProductMilestone_.endDate)), cb.desc((Expression)milestone.get(ProductMilestone_.id))});
        return query;
    }

    private MilestoneInfo mapTupleToMilestoneInfo(Tuple tuple, Optional<Integer> buildIn) {
        Integer milestoneId = (Integer)tuple.get(4);
        return MilestoneInfo.builder().productId(tuple.get(0).toString()).productName(tuple.get(1).toString()).productVersionId(tuple.get(2).toString()).productVersionVersion(tuple.get(3).toString()).milestoneId(milestoneId.toString()).milestoneVersion(tuple.get(5).toString()).milestoneEndDate(ProductMilestoneProviderImpl.toInstant(tuple.get(6))).releaseId(tuple.get(7).toString()).releaseVersion(tuple.get(8).toString()).releaseReleaseDate(ProductMilestoneProviderImpl.toInstant(tuple.get(9))).built(buildIn.map(milestoneId::equals).orElse(false).booleanValue()).build();
    }

    private static Instant toInstant(Object object) {
        if (object == null) {
            return null;
        }
        return ((Date)object).toInstant();
    }

    private Optional<Integer> getBuildInMilestone(CriteriaBuilder cb, String id) {
        CriteriaQuery buildQuery = cb.createQuery(Integer.class);
        Root artifact = buildQuery.from(Artifact.class);
        buildQuery.where((Expression)cb.equal((Expression)artifact.get(Artifact_.id), (Object)Integer.valueOf(id)));
        buildQuery.select((Selection)artifact.get(Artifact_.buildRecord).get(BuildRecord_.productMilestone).get(ProductMilestone_.id));
        buildQuery.distinct(true);
        List resultList = this.em.createQuery(buildQuery).getResultList();
        return resultList.stream().findFirst();
    }

    private List<Integer> getDependentMilestoneIds(CriteriaBuilder cb, String id) {
        CriteriaQuery buildQuery = cb.createQuery(Integer.class);
        Root artifact = buildQuery.from(Artifact.class);
        SetJoin build = artifact.join(Artifact_.dependantBuildRecords);
        buildQuery.where((Expression)cb.equal((Expression)artifact.get(Artifact_.id), (Object)Integer.valueOf(id)));
        buildQuery.select((Selection)build.get(BuildRecord_.productMilestone).get(ProductMilestone_.id));
        buildQuery.distinct(true);
        List resultList = this.em.createQuery(buildQuery).getResultList();
        return resultList;
    }
}

