/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.Product;
import org.jboss.pnc.dto.ProductRef;
import org.jboss.pnc.dto.validation.groups.ValidationGroup;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.ProductProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.ConflictedEntryValidator;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.ProductMapper;
import org.jboss.pnc.spi.datastore.predicates.ProductPredicates;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@PermitAll
@Stateless
public class ProductProviderImpl
extends AbstractProvider<Integer, org.jboss.pnc.model.Product, Product, ProductRef>
implements ProductProvider {
    @Inject
    public ProductProviderImpl(ProductRepository repository, ProductMapper mapper) {
        super(repository, mapper, org.jboss.pnc.model.Product.class);
    }

    @Override
    public void validateBeforeSaving(Product restEntity) {
        super.validateBeforeSaving(restEntity);
        this.validateIfNotConflicted(restEntity, WhenCreatingNew.class);
    }

    @Override
    public void validateBeforeUpdating(String id, Product restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        this.validateIfNotConflicted(restEntity, WhenUpdating.class);
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting products is prohibited!");
    }

    private void validateIfNotConflicted(Product productRest, Class<? extends ValidationGroup> group) throws ConflictedEntryException {
        ValidationBuilder.validateObject(productRest, WhenCreatingNew.class).validateConflict(() -> {
            org.jboss.pnc.model.Product product = (org.jboss.pnc.model.Product)this.repository.queryByPredicates(new Predicate[]{ProductPredicates.withName((String)productRest.getName())});
            Integer productId = null;
            if (productRest.getId() != null) {
                productId = Integer.valueOf(productRest.getId());
            }
            if (product != null && !product.getId().equals(productId)) {
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(product.getId(), org.jboss.pnc.model.Product.class, "Product with the same name already exists");
            }
            product = (org.jboss.pnc.model.Product)this.repository.queryByPredicates(new Predicate[]{ProductPredicates.withAbbrev((String)productRest.getAbbreviation())});
            if (product != null && !product.getId().equals(productId)) {
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(product.getId(), org.jboss.pnc.model.Product.class, "Product with the same abbreviation already exists");
            }
            return null;
        });
    }
}

