/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.bpm.BpmEventType;
import org.jboss.pnc.bpm.BpmManager;
import org.jboss.pnc.bpm.BpmTask;
import org.jboss.pnc.bpm.model.BpmStringMapNotificationRest;
import org.jboss.pnc.bpm.model.RepositoryCloneSuccess;
import org.jboss.pnc.bpm.model.RepositoryCreationProcess;
import org.jboss.pnc.bpm.task.RepositoryCreationTask;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.concurrent.MDCWrappers;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.ScmModuleConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.common.util.UrlUtils;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.notification.RepositoryCreationFailure;
import org.jboss.pnc.dto.notification.SCMRepositoryCreationSuccess;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.enums.JobNotificationType;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.SCMRepositoryProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.spi.datastore.predicates.RepositoryConfigurationPredicates;
import org.jboss.pnc.spi.datastore.repositories.RepositoryConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class SCMRepositoryProviderImpl
extends AbstractProvider<Integer, RepositoryConfiguration, SCMRepository, SCMRepository>
implements SCMRepositoryProvider {
    private static final Logger log = LoggerFactory.getLogger(SCMRepositoryProviderImpl.class);
    private ScmModuleConfig config;
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("(\\/[\\w\\.:\\~_-]+)+(\\.git)(?:\\/?|\\#[\\d\\w\\.\\-_]+?)$");
    @Inject
    private RepositoryConfigurationRepository repositoryConfigurationRepository;
    @Inject
    private UserService userService;
    @Inject
    private Notifier notifier;
    @Inject
    private BpmManager bpmManager;

    @Inject
    public SCMRepositoryProviderImpl(RepositoryConfigurationRepository repository, SCMRepositoryMapper mapper, Configuration configuration) throws ConfigurationParseException {
        super(repository, mapper, RepositoryConfiguration.class);
        this.config = (ScmModuleConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(ScmModuleConfig.class));
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting scm repositories is prohibited!");
    }

    @Override
    public Page<SCMRepository> getAllWithMatchAndSearchUrl(int pageIndex, int pageSize, String sortingRsql, String query, String matchUrl, String searchUrl) {
        ArrayList predicates = new ArrayList();
        this.addToListIfStringNotNullAndNotEmpty(predicates, matchUrl, () -> RepositoryConfigurationPredicates.matchByScmUrl((String)matchUrl));
        this.addToListIfStringNotNullAndNotEmpty(predicates, searchUrl, () -> RepositoryConfigurationPredicates.searchByScmUrl((String)searchUrl));
        Predicate[] predicatesArray = new Predicate[predicates.size()];
        predicatesArray = predicates.toArray(predicatesArray);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, predicatesArray);
    }

    private <T> void addToListIfStringNotNullAndNotEmpty(List<T> list, String str, Supplier<T> item) {
        if (str != null && !str.isEmpty()) {
            list.add(item.get());
        }
    }

    @Override
    public RepositoryCreationResponse createSCMRepository(String scmUrl, Boolean preBuildSyncEnabled) {
        return this.createSCMRepository(scmUrl, preBuildSyncEnabled, JobNotificationType.SCM_REPOSITORY_CREATION, this::onSCMRepositoryCreated);
    }

    private void onSCMRepositoryCreated(SCMRepositoryProvider.RepositoryCreated event) {
        SCMRepository repository = (SCMRepository)this.getSpecific(Integer.toString(event.getRepositoryId()));
        String taskId = event.getTaskId() == null ? null : event.getTaskId().toString();
        this.notifier.sendMessage((Object)new SCMRepositoryCreationSuccess(repository, taskId));
    }

    @Override
    public RepositoryCreationResponse createSCMRepository(String scmUrl, Boolean preBuildSyncEnabled, JobNotificationType jobType, Consumer<SCMRepositoryProvider.RepositoryCreated> consumer) {
        log.trace("Received request to start RC creation with url autodetect: " + scmUrl + " (sync enabled? " + preBuildSyncEnabled + ")");
        if (StringUtils.isEmpty((String)scmUrl)) {
            throw new InvalidEntityException("You must specify the SCM URL.");
        }
        if (scmUrl.contains(this.config.getInternalScmAuthority())) {
            this.validateInternalRepository(scmUrl);
            this.validateRepositoryWithInternalURLDoesNotExist(scmUrl);
            SCMRepository scmRepository = this.createSCMRepositoryFromValues(null, scmUrl, false);
            consumer.accept(new SCMRepositoryProvider.RepositoryCreated(null, Integer.valueOf(scmRepository.getId())));
            return new RepositoryCreationResponse(scmRepository);
        }
        this.validateRepositoryWithExternalURLDoesNotExist(scmUrl);
        boolean sync = preBuildSyncEnabled == null || preBuildSyncEnabled != false;
        RepositoryCreationTask task = this.startRCreationTask(scmUrl, sync, jobType, consumer);
        return new RepositoryCreationResponse(task.getTaskId().intValue());
    }

    @Override
    public SCMRepository update(String id, SCMRepository restEntity) {
        this.validateBeforeUpdating(id, restEntity);
        SCMRepository before = (SCMRepository)this.getSpecific(id);
        if (!before.getInternalUrl().equals(restEntity.getInternalUrl())) {
            throw new InvalidEntityException("Updating internal URL is prohibited. SCMRepo: " + id);
        }
        log.debug("Updating entity: " + restEntity.toString());
        RepositoryConfiguration saved = (RepositoryConfiguration)this.repository.save((GenericEntity)((RepositoryConfiguration)this.mapper.toEntity((DTOEntity)restEntity)));
        return (SCMRepository)this.mapper.toDTO((GenericEntity)saved);
    }

    public SCMRepository createSCMRepositoryFromValues(String externalScmUrl, String internalScmUrl, boolean preBuildSyncEnabled) {
        RepositoryConfiguration.Builder built = RepositoryConfiguration.Builder.newBuilder().internalUrl(internalScmUrl).preBuildSyncEnabled(preBuildSyncEnabled);
        if (externalScmUrl != null) {
            built.externalUrl(externalScmUrl);
        }
        RepositoryConfiguration entity = (RepositoryConfiguration)this.repository.save((GenericEntity)built.build());
        return (SCMRepository)this.mapper.toDTO((GenericEntity)entity);
    }

    public void validateInternalRepository(String internalRepoUrl) throws InvalidEntityException {
        String internalScmAuthority = this.config.getInternalScmAuthority();
        if (!SCMRepositoryProviderImpl.isInternalRepository(internalScmAuthority, internalRepoUrl).booleanValue()) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Internal repository url has to start with: <protocol>://" + internalScmAuthority + " followed by a repository name or match the pattern: " + REPOSITORY_NAME_PATTERN);
        }
        if (internalRepoUrl.contains("/gerrit/")) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Incorrect format of internal repository. Internal repository url should not contain '/gerrit/' part of the url");
        }
    }

    public static Boolean isInternalRepository(String internalScmAuthority, String internalRepoUrl) {
        if (StringUtils.isEmpty((String)internalRepoUrl) || internalScmAuthority == null) {
            throw new IllegalArgumentException("InternalScmAuthority and internalRepoUrl parameters must be set.");
        }
        String internalRepoUrlNoProto = UrlUtils.stripProtocol((String)internalRepoUrl);
        String internalRepoName = internalRepoUrlNoProto.replace(internalScmAuthority, "");
        return internalRepoUrlNoProto.startsWith(internalScmAuthority) && REPOSITORY_NAME_PATTERN.matcher(internalRepoName).matches();
    }

    private void validateRepositoryWithInternalURLDoesNotExist(String internalUrl) throws ConflictedEntryException {
        RepositoryConfiguration repositoryConfiguration;
        if (internalUrl != null && (repositoryConfiguration = this.repositoryConfigurationRepository.queryByInternalScm(internalUrl)) != null) {
            String message = "SCM Repository already exists (id: " + repositoryConfiguration.getId() + ")";
            throw new ConflictedEntryException(message, RepositoryConfiguration.class, repositoryConfiguration.getId().toString());
        }
    }

    private void validateRepositoryWithExternalURLDoesNotExist(String externalUrl) throws ConflictedEntryException {
        RepositoryConfiguration repositoryConfiguration;
        if (externalUrl != null && (repositoryConfiguration = this.repositoryConfigurationRepository.queryByExternalScm(externalUrl)) != null) {
            String message = "SCM Repository already exists (id: " + repositoryConfiguration.getId() + ")";
            throw new ConflictedEntryException(message, RepositoryConfiguration.class, repositoryConfiguration.getId().toString());
        }
    }

    private RepositoryCreationTask startRCreationTask(String externalURL, boolean preBuildSyncEnabled, JobNotificationType jobType, Consumer<SCMRepositoryProvider.RepositoryCreated> consumer) {
        String userToken = this.userService.currentUserToken();
        org.jboss.pnc.bpm.model.RepositoryConfiguration repositoryConfiguration = org.jboss.pnc.bpm.model.RepositoryConfiguration.builder().externalUrl(externalURL).preBuildSyncEnabled(Boolean.valueOf(preBuildSyncEnabled)).build();
        RepositoryCreationProcess repositoryCreationProcess = RepositoryCreationProcess.builder().repositoryConfiguration(repositoryConfiguration).build();
        RepositoryCreationTask repositoryCreationTask = new RepositoryCreationTask(repositoryCreationProcess, userToken);
        Consumer<RepositoryCloneSuccess> successListener = n -> {
            Integer taskId = repositoryCreationTask.getTaskId();
            SCMRepository repository = this.createSCMRepositoryFromValues(externalURL, n.getData().getInternalUrl(), preBuildSyncEnabled);
            SCMRepositoryProvider.RepositoryCreated notification = new SCMRepositoryProvider.RepositoryCreated(taskId, Integer.parseInt(repository.getId()));
            consumer.accept(notification);
        };
        repositoryCreationTask.addListener(BpmEventType.RC_REPO_CLONE_SUCCESS, MDCWrappers.wrap(successListener));
        this.addErrorListeners(jobType, repositoryCreationTask);
        try {
            this.bpmManager.startTask((BpmTask)repositoryCreationTask);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not start BPM task: " + repositoryCreationTask, e);
        }
        return repositoryCreationTask;
    }

    private void addErrorListeners(JobNotificationType jobType, RepositoryCreationTask task) {
        Consumer doNotifySMNError = MDCWrappers.wrap(e -> this.notifier.sendMessage((Object)this.mapError(jobType, (BpmStringMapNotificationRest)e, (BpmTask)task)));
        task.addListener(BpmEventType.RC_REPO_CREATION_ERROR, doNotifySMNError);
        task.addListener(BpmEventType.RC_REPO_CLONE_ERROR, doNotifySMNError);
    }

    private RepositoryCreationFailure mapError(JobNotificationType jobType, BpmStringMapNotificationRest notification, BpmTask task) {
        log.debug("Received BPM event error: " + notification);
        String taskId = task.getTaskId() == null ? null : task.getTaskId().toString();
        return new RepositoryCreationFailure(jobType, notification.getEventType(), (Object)notification.getData(), taskId);
    }
}

