/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Comparator;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.facade.rsql.RSQLException;
import org.jboss.pnc.facade.rsql.RSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.RSQLProducerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ComparatorRSQLNodeTraveller<DTO>
extends RSQLNodeTraveller<Comparator<DTO>> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    ComparatorRSQLNodeTraveller() {
    }

    @Override
    public Comparator<DTO> visit(LogicalNode logicalNode) {
        return null;
    }

    @Override
    public Comparator<DTO> visit(ComparisonNode node) {
        logger.trace("Sorting direction - {}, arguments {}", (Object)node.getOperator(), (Object)node.getArguments());
        Comparator<Object> comparator = null;
        for (String argument : node.getArguments()) {
            Comparator<Object> comp = Comparator.comparing(dto -> this.getProperty(dto, argument));
            if (comparator == null) {
                comparator = comp;
                continue;
            }
            comparator = comparator.thenComparing(comp);
        }
        if (comparator == null) {
            throw new RSQLException("No argument for RSQL comparsion found.");
        }
        if (node.getOperator().equals((Object)RSQLProducerImpl.DESC)) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    private Comparable getProperty(Object object, String argument) {
        try {
            String getter = "get" + StringUtils.firstCharToUpperCase((String)argument);
            Method method = object.getClass().getMethod(getter, new Class[0]);
            Object obj = method.invoke(object, new Object[0]);
            if (obj instanceof Comparable) {
                return (Comparable)obj;
            }
            throw new RSQLException("Field " + argument + " is not comparable.");
        }
        catch (NoSuchMethodException ex) {
            throw new RSQLException("Field " + argument + " not found.", ex);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            throw new RuntimeException("Could not access field " + argument + ": " + ex.getMessage(), ex);
        }
    }
}

