/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.Objects;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class BuildConfigRevisionHelper {
    private final Logger logger = LoggerFactory.getLogger(BuildConfigRevisionHelper.class);
    @Inject
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void updateBuildConfiguration(BuildConfiguration bcEntity) {
        this.buildConfigurationRepository.save((GenericEntity)bcEntity);
    }

    public BuildConfigurationRevision findRevision(String id, BuildConfiguration bcEntity) {
        return this.buildConfigurationAuditedRepository.findAllByIdOrderByRevDesc(Integer.valueOf(id)).stream().peek(p -> this.logger.warn("going through: " + p)).filter(bca -> BuildConfigRevisionHelper.equalValues(bca, bcEntity)).findFirst().map(arg_0 -> ((BuildConfigurationRevisionMapper)this.buildConfigurationRevisionMapper).toDTO(arg_0)).orElseThrow(() -> new IllegalStateException("Couldn't find updated BuildConfigurationAudited entity. BuildConfiguration to be stored: " + bcEntity));
    }

    public static boolean equalValues(BuildConfigurationAudited audited, BuildConfiguration query) {
        return audited.getName().equals(query.getName()) && Objects.equals(audited.getBuildScript(), query.getBuildScript()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)audited.getRepositoryConfiguration(), (GenericEntity<Integer>)query.getRepositoryConfiguration()) && Objects.equals(audited.getScmRevision(), query.getScmRevision()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)audited.getProject(), (GenericEntity<Integer>)query.getProject()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)audited.getBuildEnvironment(), (GenericEntity<Integer>)query.getBuildEnvironment()) && audited.getGenericParameters().equals(query.getGenericParameters());
    }

    private static boolean equalsId(GenericEntity<Integer> dbEntity, GenericEntity<Integer> query) {
        if (dbEntity == null || query == null) {
            return dbEntity == query;
        }
        return ((Integer)dbEntity.getId()).equals(query.getId());
    }
}

