/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.concurrent.MDCWrappers;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.notification.BuildConfigurationCreation;
import org.jboss.pnc.dto.requests.BuildConfigWithSCMRequest;
import org.jboss.pnc.dto.response.BuildConfigCreationResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.JobNotificationType;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.BuildConfigRevisionHelper;
import org.jboss.pnc.facade.providers.api.BuildConfigurationProvider;
import org.jboss.pnc.facade.providers.api.SCMRepositoryProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.ConflictedEntryValidator;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.BuildConfigurationMapper;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigurationPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildEnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.RepositoryConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.SequenceHandlerRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class BuildConfigurationProviderImpl
extends AbstractProvider<Integer, org.jboss.pnc.model.BuildConfiguration, BuildConfiguration, BuildConfigurationRef>
implements BuildConfigurationProvider {
    private final Logger logger = LoggerFactory.getLogger(BuildConfigurationProviderImpl.class);
    @Inject
    private ProductVersionRepository productVersionRepository;
    @Inject
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;
    @Inject
    private SCMRepositoryMapper scmRepositoryMapper;
    @Inject
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    @Inject
    private RepositoryConfigurationRepository repositoryConfigurationRepository;
    @Inject
    private BuildConfigurationSetRepository buildConfigurationSetRepository;
    @Inject
    private BuildEnvironmentRepository buildEnvironmentRepository;
    @Inject
    private SequenceHandlerRepository sequenceHandlerRepository;
    @Inject
    private Notifier notifier;
    @Inject
    private SCMRepositoryProvider scmRepositoryProvider;
    @Inject
    private BuildConfigRevisionHelper buildConfigRevisionHelper;
    @Inject
    private ProjectRepository projectRepository;
    @Inject
    private UserService userService;
    @Inject
    private UserMapper userMapper;
    private static final SCMRepository FAKE_REPOSITORY = SCMRepository.builder().id("-1").build();

    @Inject
    public BuildConfigurationProviderImpl(BuildConfigurationRepository repository, BuildConfigurationMapper mapper) {
        super(repository, mapper, org.jboss.pnc.model.BuildConfiguration.class);
    }

    @Override
    public Page<BuildConfiguration> getAll(int pageIndex, int pageSize, String sortingRsql, String query) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public BuildConfiguration store(BuildConfiguration restEntity) throws DTOValidationException {
        this.validateBeforeSaving(restEntity);
        Long id = this.sequenceHandlerRepository.getNextID("build_configuration_id_seq");
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        return super.store(restEntity.toBuilder().id(id.toString()).creationUser(user).modificationUser(user).build(), false);
    }

    @Override
    public BuildConfiguration getSpecific(String id) {
        org.jboss.pnc.model.BuildConfiguration dbEntity = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(id));
        if (dbEntity != null && dbEntity.isArchived()) {
            return null;
        }
        return (BuildConfiguration)this.mapper.toDTO((GenericEntity)dbEntity);
    }

    @Override
    public BuildConfiguration update(String id, BuildConfiguration restEntity) {
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        restEntity = restEntity.toBuilder().id(id).modificationUser(user).build();
        this.validateBeforeUpdating(id, restEntity);
        this.logger.debug("Updating entity: " + restEntity.toString());
        org.jboss.pnc.model.BuildConfiguration persistedBc = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(id));
        if (persistedBc != null) {
            if (persistedBc.getDependencies() != null) {
                persistedBc.getDependencies().isEmpty();
            }
            if (persistedBc.getDependants() != null) {
                persistedBc.getDependants().isEmpty();
            }
        }
        org.jboss.pnc.model.BuildConfiguration saved = (org.jboss.pnc.model.BuildConfiguration)this.repository.save((GenericEntity)((org.jboss.pnc.model.BuildConfiguration)this.mapper.toEntity((DTOEntity)restEntity)));
        return (BuildConfiguration)this.mapper.toDTO((GenericEntity)saved);
    }

    @Override
    protected void validateBeforeSaving(BuildConfiguration buildConfigurationRest) {
        super.validateBeforeSaving(buildConfigurationRest);
        this.validateIfItsNotConflicted(buildConfigurationRest);
        this.validateEnvironment(buildConfigurationRest);
    }

    @Override
    protected void validateBeforeUpdating(String id, BuildConfiguration buildConfigurationRest) {
        super.validateBeforeUpdating(id, buildConfigurationRest);
        this.validateIfItsNotConflicted(buildConfigurationRest);
        this.validateDependencies(id, buildConfigurationRest.getDependencies());
        this.validateEnvironment(buildConfigurationRest);
    }

    private void validateDependencies(String buildConfigId, Map<String, BuildConfigurationRef> dependencies) throws InvalidEntityException {
        if (dependencies == null || dependencies.isEmpty()) {
            return;
        }
        org.jboss.pnc.model.BuildConfiguration buildConfig = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(buildConfigId));
        for (String id : dependencies.keySet()) {
            Integer dependencyId = Integer.valueOf(id);
            ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(!buildConfig.getId().equals(dependencyId), "A build configuration cannot depend on itself");
            org.jboss.pnc.model.BuildConfiguration dependency = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)dependencyId);
            ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(!dependency.getAllDependencies().contains(buildConfig), "Cannot add dependency from : " + buildConfig.getId() + " to: " + dependencyId + " because it would introduce a cyclic dependency");
        }
    }

    private void validateIfItsNotConflicted(BuildConfiguration buildConfigurationRest) throws ConflictedEntryException, InvalidEntityException {
        ValidationBuilder.validateObject(buildConfigurationRest, WhenUpdating.class).validateConflict(() -> {
            org.jboss.pnc.model.BuildConfiguration buildConfigurationFromDB = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryByPredicates(new Predicate[]{BuildConfigurationPredicates.withName((String)buildConfigurationRest.getName()), BuildConfigurationPredicates.isNotArchived()});
            if (!(buildConfigurationFromDB == null || buildConfigurationRest.getId() != null && buildConfigurationFromDB.getId().equals(Integer.valueOf(buildConfigurationRest.getId())))) {
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(buildConfigurationFromDB.getId(), org.jboss.pnc.model.BuildConfiguration.class, "Build configuration with the same name already exists");
            }
            return null;
        });
    }

    private void validateEnvironment(BuildConfiguration buildConfigurationRest) {
        String envId = buildConfigurationRest.getEnvironment().getId();
        BuildEnvironment env = (BuildEnvironment)this.buildEnvironmentRepository.queryById((Serializable)Integer.valueOf(envId));
        if (env == null) {
            throw new EmptyEntityException("Build environment " + envId + " does not exist.");
        }
    }

    @Override
    public BuildConfigurationRevision createRevision(String id, BuildConfiguration buildConfiguration) {
        super.validateBeforeSaving(buildConfiguration.toBuilder().id(null).build());
        this.validateIfItsNotConflicted(buildConfiguration.toBuilder().id(id).build());
        this.validateDependencies(id, buildConfiguration.getDependencies());
        BuildConfigurationAudited latestRevision = this.buildConfigurationAuditedRepository.findLatestById(Integer.parseInt(id));
        if (latestRevision == null) {
            throw new RepositoryViolationException("Entity should exist in the DB");
        }
        org.jboss.pnc.model.BuildConfiguration bcEntity = (org.jboss.pnc.model.BuildConfiguration)this.mapper.toEntity((DTOEntity)buildConfiguration);
        if (BuildConfigRevisionHelper.equalValues(latestRevision, bcEntity)) {
            return this.buildConfigurationRevisionMapper.toDTO(latestRevision);
        }
        bcEntity.setCreationTime(latestRevision.getCreationTime());
        org.jboss.pnc.model.User user = this.userService.currentUser();
        bcEntity.setLastModificationUser(user);
        this.buildConfigRevisionHelper.updateBuildConfiguration(bcEntity);
        return this.buildConfigRevisionHelper.findRevision(id, bcEntity);
    }

    @Override
    public Page<BuildConfiguration> getBuildConfigurationsForProductVersion(int pageIndex, int pageSize, String sortingRsql, String query, String productVersionId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.productVersionRepository, Integer.valueOf(productVersionId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withProductVersionId((Integer)Integer.valueOf(productVersionId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<BuildConfiguration> getBuildConfigurationsForProject(int pageIndex, int pageSize, String sortingRsql, String query, String projectId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.projectRepository, Integer.valueOf(projectId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withProjectId((Integer)Integer.valueOf(projectId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<BuildConfiguration> getBuildConfigurationsForScmRepository(int pageIndex, int pageSize, String sortingRsql, String query, String scmRepositoryId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.repositoryConfigurationRepository, Integer.valueOf(scmRepositoryId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withScmRepositoryId((Integer)Integer.valueOf(scmRepositoryId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public BuildConfiguration clone(String buildConfigurationId) {
        ValidationBuilder.validateObject(WhenCreatingNew.class).validateAgainstRepository(this.repository, Integer.valueOf(buildConfigurationId), true);
        org.jboss.pnc.model.BuildConfiguration buildConfiguration = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(buildConfigurationId));
        org.jboss.pnc.model.User user = this.userService.currentUser();
        org.jboss.pnc.model.BuildConfiguration clonedBuildConfiguration = buildConfiguration.clone();
        Long id = this.sequenceHandlerRepository.getNextID("build_configuration_id_seq");
        clonedBuildConfiguration.setId(Integer.valueOf(id.intValue()));
        clonedBuildConfiguration.setCreationUser(user);
        clonedBuildConfiguration.setLastModificationUser(user);
        clonedBuildConfiguration = (org.jboss.pnc.model.BuildConfiguration)this.repository.save((GenericEntity)clonedBuildConfiguration);
        this.repository.flushAndRefresh((GenericEntity)clonedBuildConfiguration);
        this.logger.debug("Cloned saved BuildConfiguration: {}", (Object)clonedBuildConfiguration);
        return (BuildConfiguration)this.mapper.toDTO((GenericEntity)clonedBuildConfiguration);
    }

    @Override
    public void addDependency(String configId, String dependencyId) {
        org.jboss.pnc.model.BuildConfiguration buildConfig = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(configId));
        org.jboss.pnc.model.BuildConfiguration dependency = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(dependencyId));
        ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(buildConfig != null, "No build config exists with id: " + configId).validateCondition(dependency != null, "No dependency build config exists with id: " + dependencyId).validateCondition(!configId.equals(dependencyId), "A build configuration cannot depend on itself").validateCondition(!dependency.getAllDependencies().contains(buildConfig), "Cannot add dependency from : " + configId + " to: " + dependencyId + " because it would introduce a cyclic dependency");
        this.logger.debug("Didn't throw any validation errors");
        buildConfig.addDependency(dependency);
        this.repository.save((GenericEntity)buildConfig);
    }

    @Override
    public void removeDependency(String configId, String dependencyId) {
        org.jboss.pnc.model.BuildConfiguration buildConfig = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(configId));
        org.jboss.pnc.model.BuildConfiguration dependency = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(dependencyId));
        ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(buildConfig != null, "No build config exists with id: " + configId).validateCondition(dependency != null, "No dependency build config exists with id: " + dependencyId);
        buildConfig.removeDependency(dependency);
        this.repository.save((GenericEntity)buildConfig);
    }

    @Override
    public Page<BuildConfiguration> getDependencies(int pageIndex, int pageSize, String sortingRsql, String query, String configId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withDependantConfiguration((Integer)Integer.valueOf(configId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<BuildConfiguration> getDependants(int pageIndex, int pageSize, String sortingRsql, String query, String configId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withDependencyConfiguration((Integer)Integer.valueOf(configId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<BuildConfigurationRevision> getRevisions(int pageIndex, int pageSize, String id) {
        List auditedBuildConfigs = this.buildConfigurationAuditedRepository.findAllByIdOrderByRevDesc(Integer.valueOf(id));
        List toReturn = StreamHelper.nullableStreamOf((Collection)auditedBuildConfigs).map(arg_0 -> ((BuildConfigurationRevisionMapper)this.buildConfigurationRevisionMapper).toDTO(arg_0)).skip(pageIndex * pageSize).limit(pageSize).collect(Collectors.toList());
        int totalHits = auditedBuildConfigs.size();
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        return new Page(pageIndex, pageSize, totalPages, totalHits, toReturn);
    }

    @Override
    public BuildConfigurationRevision getRevision(String id, Integer rev) {
        IdRev idRev = new IdRev(Integer.valueOf(id), rev);
        BuildConfigurationAudited auditedBuildConfig = this.buildConfigurationAuditedRepository.queryById(idRev);
        return this.buildConfigurationRevisionMapper.toDTO(auditedBuildConfig);
    }

    @Override
    public Page<BuildConfiguration> getBuildConfigurationsForGroup(int pageIndex, int pageSize, String sortingRsql, String query, String groupConfigId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.buildConfigurationSetRepository, Integer.valueOf(groupConfigId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withBuildConfigurationSetId((Integer)Integer.valueOf(groupConfigId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public BuildConfigCreationResponse createWithScm(BuildConfigWithSCMRequest request) {
        BuildConfigCreationResponse response;
        ValidationBuilder.validateObject(request, WhenCreatingNew.class).validateNotEmptyArgument().validateAnnotations();
        BuildConfiguration buildConfiguration = request.getBuildConfig();
        this.validateBeforeSaving(buildConfiguration.toBuilder().scmRepository(FAKE_REPOSITORY).build());
        Long buildConfigurationId = this.sequenceHandlerRepository.getNextID("build_configuration_id_seq");
        MDCUtils.addProcessContext((String)buildConfigurationId.toString());
        BuildConfiguration newBuildConfigurationWithId = buildConfiguration.toBuilder().id(buildConfigurationId.toString()).build();
        RepositoryCreationResponse rcResponse = this.scmRepositoryProvider.createSCMRepository(request.getScmUrl(), request.getPreBuildSyncEnabled(), JobNotificationType.BUILD_CONFIG_CREATION, MDCWrappers.wrap(repositoryConfigurationId -> this.onRCCreationSuccess((SCMRepositoryProvider.RepositoryCreated)repositoryConfigurationId, newBuildConfigurationWithId)));
        if (rcResponse.getTaskId() == null) {
            org.jboss.pnc.model.BuildConfiguration buildConfigurationFromDB = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryByPredicates(new Predicate[]{BuildConfigurationPredicates.withName((String)newBuildConfigurationWithId.getName()), BuildConfigurationPredicates.isNotArchived()});
            response = new BuildConfigCreationResponse((BuildConfiguration)this.mapper.toDTO((GenericEntity)buildConfigurationFromDB));
        } else {
            response = new BuildConfigCreationResponse(rcResponse.getTaskId().toString());
        }
        MDCUtils.removeProcessContext();
        return response;
    }

    @Override
    public Optional<BuildConfiguration> restoreRevision(String id, int rev) {
        IdRev idRev = new IdRev(Integer.valueOf(id), Integer.valueOf(rev));
        BuildConfigurationAudited buildConfigurationAudited = this.buildConfigurationAuditedRepository.queryById(idRev);
        org.jboss.pnc.model.BuildConfiguration originalBC = (org.jboss.pnc.model.BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(id));
        org.jboss.pnc.model.User user = this.userService.currentUser();
        if (buildConfigurationAudited == null || originalBC == null) {
            return Optional.empty();
        }
        originalBC.setName(buildConfigurationAudited.getName());
        originalBC.setBuildScript(buildConfigurationAudited.getBuildScript());
        originalBC.setRepositoryConfiguration(buildConfigurationAudited.getRepositoryConfiguration());
        originalBC.setScmRevision(buildConfigurationAudited.getScmRevision());
        originalBC.setBuildType(buildConfigurationAudited.getBuildType());
        originalBC.setBuildEnvironment(buildConfigurationAudited.getBuildEnvironment());
        originalBC.setGenericParameters(buildConfigurationAudited.getGenericParameters());
        originalBC.setLastModificationUser(user);
        org.jboss.pnc.model.BuildConfiguration newBc = (org.jboss.pnc.model.BuildConfiguration)this.repository.save((GenericEntity)originalBC);
        newBc.getBuildConfigurationSets().forEach(BuildConfigurationSet::getId);
        newBc.getDependencies().forEach(org.jboss.pnc.model.BuildConfiguration::getId);
        this.repository.flushAndRefresh((GenericEntity)newBc);
        return Optional.of((BuildConfiguration)this.mapper.toDTO((GenericEntity)newBc));
    }

    private void onRCCreationSuccess(SCMRepositoryProvider.RepositoryCreated event, BuildConfiguration configuration) {
        boolean sendMessage;
        int scmRepositoryId = event.getRepositoryId();
        RepositoryConfiguration repositoryConfiguration = (RepositoryConfiguration)this.repositoryConfigurationRepository.queryById((Serializable)Integer.valueOf(scmRepositoryId));
        String taskId = event.getTaskId() == null ? null : event.getTaskId().toString();
        boolean bl = sendMessage = event.getTaskId() != null;
        if (repositoryConfiguration == null) {
            String errorMessage = "Repository Configuration was not found in database.";
            this.logger.error(errorMessage);
            if (sendMessage) {
                this.sendErrorMessage(SCMRepository.builder().id(Integer.toString(scmRepositoryId)).build(), null, errorMessage, taskId);
                return;
            }
            throw new RepositoryViolationException("Repository Configuration was not found in database.");
        }
        org.jboss.pnc.model.BuildConfiguration buildConfiguration = (org.jboss.pnc.model.BuildConfiguration)this.mapper.toEntity((DTOEntity)configuration);
        buildConfiguration.setRepositoryConfiguration(repositoryConfiguration);
        org.jboss.pnc.model.BuildConfiguration buildConfigurationSaved = (org.jboss.pnc.model.BuildConfiguration)this.repository.save((GenericEntity)buildConfiguration);
        Set<Integer> bcSetIds = configuration.getGroupConfigs() == null ? Collections.emptySet() : configuration.getGroupConfigs().keySet().stream().map(Integer::valueOf).collect(Collectors.toSet());
        SCMRepository scmRepository = this.scmRepositoryMapper.toDTO(repositoryConfiguration);
        BuildConfiguration buildConfig = (BuildConfiguration)this.mapper.toDTO((GenericEntity)buildConfigurationSaved);
        try {
            this.addBuildConfigurationToSet(buildConfigurationSaved, bcSetIds);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            if (sendMessage) {
                this.sendErrorMessage(scmRepository, (BuildConfigurationRef)buildConfig, e.getMessage(), taskId);
                return;
            }
            throw new RepositoryViolationException("Failed to add BuildConfig to BuildConfigSets.");
        }
        if (sendMessage) {
            BuildConfigurationCreation successMessage = BuildConfigurationCreation.success((SCMRepository)scmRepository, (BuildConfigurationRef)buildConfig, (String)taskId);
            this.notifier.sendMessage((Object)successMessage);
        }
    }

    private void addBuildConfigurationToSet(org.jboss.pnc.model.BuildConfiguration buildConfig, Set<Integer> bcSetIds) {
        HashSet<String> notFoundSets = null;
        for (Integer setId : bcSetIds) {
            BuildConfigurationSet bcSet = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryById((Serializable)setId);
            if (bcSet == null) {
                if (notFoundSets == null) {
                    notFoundSets = new HashSet<String>();
                }
                notFoundSets.add(setId.toString());
                continue;
            }
            if (bcSet.getBuildConfigurations().contains(buildConfig)) continue;
            bcSet.addBuildConfiguration(buildConfig);
            this.buildConfigurationSetRepository.save((GenericEntity)bcSet);
        }
        if (notFoundSets != null) {
            String ids = String.join((CharSequence)", ", notFoundSets);
            throw new IllegalArgumentException("No group configuration exists for ids: " + ids);
        }
    }

    private void sendErrorMessage(SCMRepository scmRepository, BuildConfigurationRef buildConfig, String message, String taskId) {
        BuildConfigurationCreation errorMessage = BuildConfigurationCreation.error((SCMRepository)scmRepository, (BuildConfigurationRef)buildConfig, (String)message, (String)taskId);
        this.notifier.sendMessage((Object)errorMessage);
    }
}

