/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.ProductVersionProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.spi.datastore.predicates.ProductVersionPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;

@PermitAll
@Stateless
public class ProductVersionProviderImpl
extends AbstractProvider<Integer, ProductVersion, org.jboss.pnc.dto.ProductVersion, ProductVersionRef>
implements ProductVersionProvider {
    private ProductRepository productRepository;
    private BuildConfigurationSetRepository groupConfigRepository;
    private SystemConfig systemConfig;
    private BuildConfigurationRepository buildConfigurationRepository;

    @Inject
    public ProductVersionProviderImpl(ProductVersionRepository repository, ProductVersionMapper mapper, ProductRepository productRepository, BuildConfigurationSetRepository groupConfigRepository, BuildConfigurationRepository buildConfigurationRepository, SystemConfig systemConfig) {
        super(repository, mapper, ProductVersion.class);
        this.productRepository = productRepository;
        this.groupConfigRepository = groupConfigRepository;
        this.systemConfig = systemConfig;
        this.buildConfigurationRepository = buildConfigurationRepository;
    }

    @Override
    public org.jboss.pnc.dto.ProductVersion store(org.jboss.pnc.dto.ProductVersion restEntity) {
        this.validateBeforeSaving(restEntity);
        ProductVersion productVersionRestDb = (ProductVersion)this.mapper.toEntity((DTOEntity)restEntity);
        Product product = (Product)this.productRepository.queryById((Serializable)Integer.valueOf(restEntity.getProduct().getId()));
        productVersionRestDb.generateBrewTagPrefix(product.getAbbreviation(), restEntity.getVersion(), this.systemConfig.getBrewTagPattern());
        ProductVersion productVersion = (ProductVersion)this.repository.save((GenericEntity)productVersionRestDb);
        this.repository.flushAndRefresh((GenericEntity)productVersion);
        return (org.jboss.pnc.dto.ProductVersion)this.mapper.toDTO((GenericEntity)productVersion);
    }

    @Override
    public org.jboss.pnc.dto.ProductVersion update(String id, org.jboss.pnc.dto.ProductVersion restEntity) {
        boolean changingVersion;
        this.validateBeforeUpdating(id, restEntity);
        org.jboss.pnc.dto.ProductVersion current = (org.jboss.pnc.dto.ProductVersion)super.getSpecific(id);
        boolean hasClosedMilestone = current.getProductMilestones().values().stream().anyMatch(milestone -> milestone.getEndDate() != null);
        boolean bl = changingVersion = !current.getVersion().equals(restEntity.getVersion());
        if (changingVersion && hasClosedMilestone) {
            throw new InvalidEntityException("Cannot change version id due to having closed milestone. Product version id: " + id);
        }
        ProductVersion managedModel = (ProductVersion)this.repository.queryById((Serializable)Integer.valueOf(Integer.parseInt(id)));
        ProductVersion updatedModel = (ProductVersion)this.mapper.toEntity((DTOEntity)restEntity);
        this.groupConfigRepository.cascadeUpdates((GenericEntity)managedModel, (GenericEntity)updatedModel, ProductVersion::getBuildConfigurationSets, BuildConfigurationSet::setProductVersion, new Predicate[0]);
        this.buildConfigurationRepository.cascadeUpdates((GenericEntity)managedModel, (GenericEntity)updatedModel, ProductVersion::getBuildConfigurations, BuildConfiguration::setProductVersion, new Predicate[0]);
        return super.update(id, restEntity);
    }

    @Override
    protected void validateBeforeSaving(org.jboss.pnc.dto.ProductVersion restEntity) {
        super.validateBeforeSaving(restEntity);
        Product product = (Product)this.productRepository.queryById((Serializable)Integer.valueOf(restEntity.getProduct().getId()));
        if (product == null) {
            throw new InvalidEntityException("Product with id: " + restEntity.getProduct().getId() + " does not exist.");
        }
        Set productVersionList = product.getProductVersions();
        if (productVersionList == null) {
            return;
        }
        productVersionList.stream().filter(pv -> pv.getVersion().equals(restEntity.getVersion())).findFirst().ifPresent(pv -> {
            throw new ConflictedEntryException("Product version with version " + restEntity.getVersion() + " already exists", ProductVersion.class, pv.getId().toString());
        });
    }

    @Override
    protected void validateBeforeUpdating(String id, org.jboss.pnc.dto.ProductVersion restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        if (restEntity.getGroupConfigs() != null) {
            for (String groupConfigId : restEntity.getGroupConfigs().keySet()) {
                BuildConfigurationSet set = (BuildConfigurationSet)this.groupConfigRepository.queryById((Serializable)Integer.valueOf(groupConfigId));
                if (set == null) {
                    throw new InvalidEntityException("Group config with id: " + groupConfigId + " does not exist.");
                }
                if (set.getProductVersion() == null || set.getProductVersion().getId().toString().equals(id)) continue;
                throw new ConflictedEntryException("Group config with id: " + groupConfigId + " already belongs to different product version.", ProductVersion.class, set.getProductVersion().getId().toString());
            }
        }
    }

    @Override
    public Page<org.jboss.pnc.dto.ProductVersion> getAllForProduct(int pageIndex, int pageSize, String sortingRsql, String query, String productId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ProductVersionPredicates.withProductId((Integer)Integer.valueOf(productId)));
    }
}

