/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.jboss.pnc.facade.rsql.RSQLException;
import org.jboss.pnc.facade.rsql.RSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.RSQLProducerImpl;
import org.jboss.pnc.facade.rsql.RSQLSelectorPath;
import org.jboss.pnc.model.GenericEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityRSQLNodeTraveller<DB extends GenericEntity<Integer>>
extends RSQLNodeTraveller<Predicate> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Root<DB> root;
    private final CriteriaBuilder cb;
    private final BiFunction<From<?, DB>, RSQLSelectorPath, Path> toPath;

    public EntityRSQLNodeTraveller(Root<DB> root, CriteriaBuilder cb, BiFunction<From<?, DB>, RSQLSelectorPath, Path> toPath) {
        this.root = root;
        this.cb = cb;
        this.toPath = toPath;
    }

    @Override
    public Predicate visit(LogicalNode node) {
        logger.trace("Parsing LogicalNode {}", (Object)node);
        return this.proceedEmbeddedNodes(node);
    }

    @Override
    public Predicate visit(ComparisonNode node) {
        logger.trace("Parsing ComparisonNode {}", (Object)node);
        return this.proceedSelection(node);
    }

    private Predicate proceedSelection(ComparisonNode node) {
        RSQLSelectorPath selector = RSQLSelectorPath.get(node.getSelector());
        Path path = this.toPath.apply((From<?, DB>)this.root, selector);
        List arguments = node.getArguments();
        ComparisonOperator operator = node.getOperator();
        if (RSQLOperators.EQUAL.equals((Object)operator)) {
            Object argument = this.cast((String)arguments.get(0), path.getJavaType());
            return this.cb.equal((Expression)path, argument);
        }
        if (RSQLOperators.NOT_EQUAL.equals((Object)operator)) {
            Object argument = this.cast((String)arguments.get(0), path.getJavaType());
            return this.cb.notEqual((Expression)path, argument);
        }
        if (RSQLOperators.GREATER_THAN.equals((Object)operator)) {
            Object argument = this.cast((String)arguments.get(0), path.getJavaType());
            return this.cb.greaterThan((Expression)path, argument);
        }
        if (RSQLOperators.GREATER_THAN_OR_EQUAL.equals((Object)operator)) {
            Object argument = this.cast((String)arguments.get(0), path.getJavaType());
            return this.cb.greaterThanOrEqualTo((Expression)path, argument);
        }
        if (RSQLOperators.LESS_THAN.equals((Object)operator)) {
            Object argument = this.cast((String)arguments.get(0), path.getJavaType());
            return this.cb.lessThan((Expression)path, argument);
        }
        if (RSQLOperators.LESS_THAN_OR_EQUAL.equals((Object)operator)) {
            Object argument = this.cast((String)arguments.get(0), path.getJavaType());
            return this.cb.lessThanOrEqualTo((Expression)path, argument);
        }
        if (RSQLOperators.IN.equals((Object)operator)) {
            List castArguments = this.castArguments(arguments, path.getJavaType());
            return path.in(castArguments);
        }
        if (RSQLOperators.NOT_IN.equals((Object)operator)) {
            List castArguments = this.castArguments(arguments, path.getJavaType());
            return this.cb.not((Expression)path.in(castArguments));
        }
        if (RSQLProducerImpl.LIKE.equals((Object)operator)) {
            return this.cb.like(this.cb.lower((Expression)path), this.preprocessLikeOperatorArgument(((String)arguments.get(0)).toLowerCase()));
        }
        if (RSQLProducerImpl.NOT_LIKE.equals((Object)operator)) {
            return this.cb.not((Expression)this.cb.like(this.cb.lower((Expression)path), this.preprocessLikeOperatorArgument(((String)arguments.get(0)).toLowerCase())));
        }
        if (RSQLProducerImpl.IS_NULL.equals((Object)operator)) {
            if (Boolean.parseBoolean((String)arguments.get(0))) {
                return this.cb.isNull((Expression)path);
            }
            return this.cb.isNotNull((Expression)path);
        }
        throw new UnsupportedOperationException("Not Implemented yet!");
    }

    private Predicate proceedEmbeddedNodes(LogicalNode node) {
        Iterator iterator = node.iterator();
        Predicate p1 = (Predicate)this.visit((Node)iterator.next());
        Predicate p2 = (Predicate)this.visit((Node)iterator.next());
        if (node instanceof AndNode) {
            Predicate pCombined = this.cb.and((Expression)p1, (Expression)p2);
            while (iterator.hasNext()) {
                Predicate pNext = (Predicate)this.visit((Node)iterator.next());
                pCombined = this.cb.and((Expression)pCombined, (Expression)pNext);
            }
            return pCombined;
        }
        if (node instanceof OrNode) {
            Predicate pCombined = this.cb.or((Expression)p1, (Expression)p2);
            while (iterator.hasNext()) {
                Predicate pNext = (Predicate)this.visit((Node)iterator.next());
                pCombined = this.cb.or((Expression)pCombined, (Expression)pNext);
            }
            return pCombined;
        }
        throw new UnsupportedOperationException("Logical operation not supported");
    }

    private String preprocessLikeOperatorArgument(String argument) {
        return argument.replaceAll("\\?", "_").replaceAll("\\*", "%");
    }

    private <T extends Comparable<? super T>> List<T> castArguments(List<String> arguments, Class<T> javaType) {
        if (javaType == String.class) {
            return arguments;
        }
        return arguments.stream().map(a -> this.cast((String)a, javaType)).collect(Collectors.toList());
    }

    private <T extends Comparable<? super T>> T cast(String argument, Class<T> javaType) {
        if (javaType.isEnum()) {
            Class<T> enumType = javaType;
            return Enum.valueOf(enumType, argument);
        }
        if (javaType == String.class) {
            return (T)argument;
        }
        if (javaType == Integer.class || javaType == Integer.TYPE) {
            return (T)Integer.valueOf(argument);
        }
        if (javaType == Long.class || javaType == Long.TYPE) {
            return (T)Long.valueOf(argument);
        }
        if (javaType == Boolean.class || javaType == Boolean.TYPE) {
            return (T)Boolean.valueOf(argument);
        }
        if (javaType == Date.class) {
            try {
                DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(argument, timeFormatter);
                return (T)Date.from(Instant.from(offsetDateTime));
            }
            catch (DateTimeParseException ex) {
                throw new RSQLException("The datetime must be in the ISO-8601 format with timezone, e.g. 1970-01-01T00:00:00Z, was " + argument, ex);
            }
        }
        throw new UnsupportedOperationException("The target type " + javaType + " is not known to the type converter.");
    }
}

