/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.datastore.limits.rsql.EmptySortInfo;
import org.jboss.pnc.datastore.predicates.rsql.EmptyRSQLPredicate;
import org.jboss.pnc.facade.rsql.ComparatorRSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.EntityRSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.RSQLException;
import org.jboss.pnc.facade.rsql.RSQLProducer;
import org.jboss.pnc.facade.rsql.RSQLSelectorPath;
import org.jboss.pnc.facade.rsql.SortRSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.StreamRSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.mapper.UniversalRSQLMapper;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RSQLProducerImpl
implements RSQLProducer {
    private static final Logger logger = LoggerFactory.getLogger(RSQLProducerImpl.class);
    private final RSQLParser predicateParser;
    private final RSQLParser sortParser;
    private static final Pattern likePattern = Pattern.compile("(\\%[a-zA-Z0-9\\s]+\\%)");
    static final String UNKNOWN_PART_PLACEHOLDER = "_";
    private static final String FIXED_START_OF_SORTING_EXPRESSION = "sort";
    static final ComparisonOperator LIKE = new ComparisonOperator(new String[]{"=like=", "=LIKE="});
    static final ComparisonOperator NOT_LIKE = new ComparisonOperator(new String[]{"=notlike=", "=NOTLIKE="});
    static final ComparisonOperator IS_NULL = new ComparisonOperator(new String[]{"=isnull=", "=ISNULL="});
    static final ComparisonOperator ASC = new ComparisonOperator("=asc=", true);
    static final ComparisonOperator DESC = new ComparisonOperator("=desc=", true);
    @Inject
    UniversalRSQLMapper mapper;

    public RSQLProducerImpl() {
        Set predicateOperators = RSQLOperators.defaultOperators();
        predicateOperators.add(LIKE);
        predicateOperators.add(NOT_LIKE);
        predicateOperators.add(IS_NULL);
        this.predicateParser = new RSQLParser(predicateOperators);
        HashSet<ComparisonOperator> sortOperators = new HashSet<ComparisonOperator>();
        sortOperators.add(ASC);
        sortOperators.add(DESC);
        this.sortParser = new RSQLParser(sortOperators);
    }

    @Override
    public <DB extends GenericEntity<?>> org.jboss.pnc.spi.datastore.repositories.api.Predicate<DB> getCriteriaPredicate(Class<DB> type, String rsql) {
        if (rsql == null || rsql.isEmpty()) {
            return new EmptyRSQLPredicate();
        }
        Node rootNode = this.predicateParser.parse(this.preprocessRSQL(rsql));
        return this.getEntityPredicate(rootNode, type);
    }

    public <T> Predicate<T> getStreamPredicate(String rsql) {
        if (rsql == null || rsql.isEmpty()) {
            return x -> true;
        }
        Node rootNode = this.predicateParser.parse(this.preprocessRSQL(rsql));
        return this.getStreamPredicate(rootNode);
    }

    @Override
    public <DB extends GenericEntity<?>> SortInfo getSortInfo(Class<DB> type, String rsql) {
        if (rsql == null || rsql.isEmpty()) {
            return new EmptySortInfo();
        }
        if (!rsql.startsWith(FIXED_START_OF_SORTING_EXPRESSION)) {
            rsql = FIXED_START_OF_SORTING_EXPRESSION + rsql;
        }
        Node rootNode = this.sortParser.parse(this.preprocessRSQL(rsql));
        Function<RSQLSelectorPath, String> toPath = selector -> this.mapper.toPath(type, (RSQLSelectorPath)selector);
        return (SortInfo)rootNode.accept(new SortRSQLNodeTraveller(toPath));
    }

    @Override
    public <DTO> Comparator<DTO> getComparator(String rsql) {
        if (rsql == null || rsql.isEmpty()) {
            throw new RSQLException("RSQL sort query must be non-empty and non-null.");
        }
        if (!rsql.startsWith(FIXED_START_OF_SORTING_EXPRESSION)) {
            rsql = FIXED_START_OF_SORTING_EXPRESSION + rsql;
        }
        Node rootNode = this.sortParser.parse(this.preprocessRSQL(rsql));
        return (Comparator)rootNode.accept(new ComparatorRSQLNodeTraveller());
    }

    private String preprocessRSQL(String rsql) {
        String result = rsql;
        Matcher matcher = likePattern.matcher(rsql);
        while (matcher.find()) {
            result = rsql.replaceAll(matcher.group(1), matcher.group(1).replaceAll("\\s", UNKNOWN_PART_PLACEHOLDER));
        }
        return result;
    }

    private <DB extends GenericEntity<?>> org.jboss.pnc.spi.datastore.repositories.api.Predicate<DB> getEntityPredicate(Node rootNode, Class<DB> type) {
        return (root, query, cb) -> {
            EntityRSQLNodeTraveller visitor = new EntityRSQLNodeTraveller(root, cb, (from, selector) -> this.mapper.toPath(type, from, (RSQLSelectorPath)selector));
            return (javax.persistence.criteria.Predicate)rootNode.accept(visitor);
        };
    }

    private <T> Predicate<T> getStreamPredicate(Node rootNode) {
        return instance -> {
            StreamRSQLNodeTraveller visitor = new StreamRSQLNodeTraveller(instance);
            return (Boolean)rootNode.accept((RSQLVisitor)visitor);
        };
    }
}

