/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql.mapper;

import java.io.Serializable;
import javax.inject.Inject;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.SingularAttribute;
import org.jboss.pnc.facade.rsql.RSQLException;
import org.jboss.pnc.facade.rsql.RSQLSelectorPath;
import org.jboss.pnc.facade.rsql.mapper.RSQLMapper;
import org.jboss.pnc.facade.rsql.mapper.UniversalRSQLMapper;
import org.jboss.pnc.model.GenericEntity;

public abstract class AbstractRSQLMapper<ID extends Serializable, DB extends GenericEntity<ID>>
implements RSQLMapper<ID, DB> {
    @Inject
    private UniversalRSQLMapper mapper;
    private final Class<DB> type;

    public AbstractRSQLMapper(Class<DB> type) {
        this.type = type;
    }

    @Override
    public Class<DB> type() {
        return this.type;
    }

    @Override
    public Path<?> toPath(From<?, DB> from, RSQLSelectorPath selector) {
        String name = selector.getElement();
        if (this.toAttribute(name) != null) {
            return from.get(this.toAttribute(name));
        }
        if (this.toEntity(name) != null) {
            if (selector.isFinal()) {
                return from.get(this.toEntity(name));
            }
            return this.mapEntity(from, this.toEntity(name), selector.next());
        }
        throw new RSQLException("Unknown RSQL selector " + name + " for type " + this.type);
    }

    protected <X extends GenericEntity<?>> Path<?> mapEntity(From<?, DB> from, SingularAttribute<DB, X> entity, RSQLSelectorPath selector) {
        Class bindableJavaType = entity.getBindableJavaType();
        Join join = from.join(entity);
        return this.mapper.toPath(bindableJavaType, join, selector);
    }

    @Override
    public String toPath(RSQLSelectorPath selector) {
        String name = selector.getElement();
        if (this.toAttribute(name) != null) {
            return this.toAttribute(name).getName();
        }
        SingularAttribute<DB, GenericEntity<?>> entity = this.toEntity(name);
        if (entity != null) {
            Class bindableType = entity.getBindableJavaType();
            return entity.getName() + "." + this.mapper.toPath(bindableType, selector.next());
        }
        throw new RSQLException("Unknown RSQL selector " + name + " for type " + this.type);
    }

    protected abstract SingularAttribute<DB, ? extends GenericEntity<?>> toEntity(String var1);

    protected abstract SingularAttribute<DB, ?> toAttribute(String var1);
}

