/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import com.google.common.collect.ObjectArrays;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenDeleting;
import org.jboss.pnc.facade.providers.api.Provider;
import org.jboss.pnc.facade.rsql.RSQLProducer;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.EntityMapper;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.PageInfoProducer;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.Repository;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
public abstract class AbstractProvider<ID extends Serializable, DB extends GenericEntity<ID>, DTO extends REF, REF extends DTOEntity>
implements Provider<ID, DB, DTO, REF> {
    private static final Logger log = LoggerFactory.getLogger(AbstractProvider.class);
    @Inject
    protected RSQLProducer rsqlPredicateProducer;
    @Inject
    protected PageInfoProducer pageInfoProducer;
    protected Repository<DB, ID> repository;
    protected EntityMapper<ID, DB, DTO, REF> mapper;
    protected final Class<DB> type;

    public AbstractProvider(Repository<DB, ID> repository, EntityMapper<ID, DB, DTO, REF> mapper, Class<DB> type) {
        this.repository = repository;
        this.mapper = mapper;
        this.type = type;
    }

    public EntityMapper<ID, DB, DTO, REF> mapper() {
        return this.mapper;
    }

    @Override
    public DTO getSpecific(String stringId) {
        ID id = this.parseId(stringId);
        GenericEntity dbEntity = this.repository.queryById(id);
        return (DTO)this.mapper.toDTO(dbEntity);
    }

    @Override
    public DTO store(DTO restEntity) throws DTOValidationException {
        return this.store(restEntity, true);
    }

    protected DTO store(DTO restEntity, boolean validateBeforeSaving) throws DTOValidationException {
        if (validateBeforeSaving) {
            this.validateBeforeSaving(restEntity);
        }
        log.debug("Storing entity: " + restEntity.toString());
        GenericEntity storedEntity = this.repository.save(this.mapper.toEntity(restEntity));
        this.repository.flushAndRefresh(storedEntity);
        return (DTO)this.mapper.toDTO(storedEntity);
    }

    @Override
    public Page<DTO> getAll(int pageIndex, int pageSize, String sortingRsql, String query) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, new Predicate[0]);
    }

    @Override
    public DTO update(String id, DTO restEntity) {
        throw new UnsupportedOperationException("Update operation not supported.");
    }

    @Override
    public void delete(String stringId) {
        ID id = this.parseId(stringId);
        this.validateBeforeDeleting(id);
        this.repository.delete(id);
    }

    @Override
    public Page<DTO> queryForCollection(int pageIndex, int pageSize, String sortingRsql, String query, Predicate<DB> ... predicates) {
        Predicate<DB> rsqlPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(this.type, query);
        PageInfo pageInfo = this.pageInfoProducer.getPageInfo(pageIndex, pageSize);
        SortInfo sortInfo = this.rsqlPredicateProducer.getSortInfo(this.type, sortingRsql);
        List collection = this.repository.queryWithPredicates(pageInfo, sortInfo, (Predicate[])ObjectArrays.concat(rsqlPredicate, (Object[])predicates));
        int totalHits = this.repository.count((Predicate[])ObjectArrays.concat(rsqlPredicate, (Object[])predicates));
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        List content = StreamHelper.nullableStreamOf((Collection)collection).map(arg_0 -> this.mapper.toDTO(arg_0)).collect(Collectors.toList());
        return new Page(pageIndex, pageSize, totalPages, totalHits, content);
    }

    protected void validateBeforeSaving(DTO restEntity) {
        ValidationBuilder.validateObject(restEntity, WhenCreatingNew.class).validateNotEmptyArgument().validateAnnotations();
    }

    protected void validateBeforeDeleting(ID id) {
        ValidationBuilder.validateObject(WhenDeleting.class).validateAgainstRepository(this.repository, id, true).validateAnnotations();
    }

    protected ID parseId(String stringId) {
        try {
            return (ID)((Serializable)this.mapper.getIdMapper().toEntity((Object)stringId));
        }
        catch (NumberFormatException ex) {
            throw new EmptyEntityException("Error parsing id " + stringId);
        }
    }
}

