/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.bpm.BpmEventType;
import org.jboss.pnc.bpm.BpmManager;
import org.jboss.pnc.bpm.BpmTask;
import org.jboss.pnc.bpm.RestConnector;
import org.jboss.pnc.bpm.model.BpmStringMapNotificationRest;
import org.jboss.pnc.bpm.model.RepositoryCloneSuccess;
import org.jboss.pnc.bpm.model.RepositoryCreationProcess;
import org.jboss.pnc.bpm.task.RepositoryCreationTask;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.concurrent.MDCWrappers;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.ScmModuleConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.common.util.UrlUtils;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.notification.RepositoryCreationFailure;
import org.jboss.pnc.dto.notification.SCMRepositoryCreationSuccess;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.dto.tasks.RepositoryCreationResult;
import org.jboss.pnc.enums.JobNotificationType;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.BuildConfigurationProvider;
import org.jboss.pnc.facade.providers.api.SCMRepositoryProvider;
import org.jboss.pnc.facade.util.RepourClient;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.spi.datastore.predicates.RepositoryConfigurationPredicates;
import org.jboss.pnc.spi.datastore.repositories.RepositoryConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.exception.ProcessManagerException;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class SCMRepositoryProviderImpl
extends AbstractUpdatableProvider<Integer, RepositoryConfiguration, SCMRepository, SCMRepository>
implements SCMRepositoryProvider {
    private static final Logger log = LoggerFactory.getLogger(SCMRepositoryProviderImpl.class);
    private static final String RC_REPO_CREATION_CONFLICT = "RC_REPO_CREATION_CONFLICT";
    private ScmModuleConfig config;
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("(\\/[\\w\\.:\\~_-]+)+(\\.git)(?:\\/?|\\#[\\d\\w\\.\\-_]+?)$");
    @Inject
    private RepositoryConfigurationRepository repositoryConfigurationRepository;
    @Inject
    private UserService userService;
    @Inject
    private Notifier notifier;
    @Inject
    private BpmManager bpmManager;
    @Inject
    private BpmModuleConfig bpmConfig;
    @Inject
    private GlobalModuleGroup globalConfig;
    @Inject
    private RepourClient repour;
    @Inject
    private BuildConfigurationProvider buildConfigurationProvider;

    @Inject
    public SCMRepositoryProviderImpl(RepositoryConfigurationRepository repository, SCMRepositoryMapper mapper, Configuration configuration) throws ConfigurationParseException {
        super(repository, mapper, RepositoryConfiguration.class);
        this.config = (ScmModuleConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(ScmModuleConfig.class));
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting scm repositories is prohibited!");
    }

    @Override
    public Page<SCMRepository> getAllWithMatchAndSearchUrl(int pageIndex, int pageSize, String sortingRsql, String query, String matchUrl, String searchUrl) {
        ArrayList<Predicate<Predicate>> predicates = new ArrayList<Predicate<Predicate>>();
        this.validateAndAddPredicate(predicates, matchUrl, RepositoryConfigurationPredicates::matchByScmUrl);
        this.validateAndAddPredicate(predicates, searchUrl, RepositoryConfigurationPredicates::searchByScmUrl);
        Predicate[] predicatesArray = new Predicate[predicates.size()];
        predicatesArray = predicates.toArray(predicatesArray);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, predicatesArray);
    }

    private <T> void validateAndAddPredicate(List<Predicate<T>> list, String str, Function<String, Predicate<T>> item) {
        if (str != null && !str.isEmpty()) {
            try {
                list.add(item.apply(str));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidEntityException(ex.getMessage());
            }
        }
    }

    @Override
    public RepositoryCreationResponse createSCMRepository(String scmUrl, Boolean preBuildSyncEnabled) {
        return this.createSCMRepository(scmUrl, preBuildSyncEnabled, JobNotificationType.SCM_REPOSITORY_CREATION, this::notifySCMRepositoryCreated, Optional.empty());
    }

    private void notifySCMRepositoryCreated(SCMRepositoryProvider.RepositoryCreated event) {
        String taskId;
        SCMRepository repository = (SCMRepository)this.getSpecific(Integer.toString(event.getRepositoryId()));
        String string = taskId = event.getTaskId() == null ? null : event.getTaskId().toString();
        if (taskId != null) {
            this.notifier.sendMessage((Object)new SCMRepositoryCreationSuccess(repository, taskId));
        }
    }

    @Override
    public RepositoryCreationResponse createSCMRepository(String scmUrl, Boolean preBuildSyncEnabled, JobNotificationType jobType, Consumer<SCMRepositoryProvider.RepositoryCreated> consumer, Optional<BuildConfiguration> buildConfiguration) {
        log.trace("Received request to start RC creation with url autodetect: " + scmUrl + " (sync enabled? " + preBuildSyncEnabled + ")");
        if (StringUtils.isEmpty((String)scmUrl)) {
            throw new InvalidEntityException("You must specify the SCM URL.");
        }
        if (scmUrl.contains(this.config.getInternalScmAuthority())) {
            this.validateInternalRepository(scmUrl);
            this.validateRepositoryWithInternalURLDoesNotExist(scmUrl, null);
            SCMRepository scmRepository = this.createSCMRepositoryFromValues(null, scmUrl, false);
            consumer.accept(new SCMRepositoryProvider.RepositoryCreated(null, Integer.valueOf(scmRepository.getId())));
            return new RepositoryCreationResponse(scmRepository);
        }
        this.validateRepositoryWithExternalURLDoesNotExist(scmUrl, null);
        boolean sync = preBuildSyncEnabled == null || preBuildSyncEnabled != false;
        Integer taskId = this.startRCreationTask(scmUrl, sync, jobType, consumer, buildConfiguration);
        return new RepositoryCreationResponse(taskId.intValue());
    }

    @Override
    public void validateBeforeUpdating(Integer id, SCMRepository restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        RepositoryConfiguration entityInDb = (RepositoryConfiguration)this.findInDB(id);
        if (!entityInDb.getInternalUrl().equals(restEntity.getInternalUrl())) {
            throw new InvalidEntityException("Updating internal URL is prohibited. SCMRepo: " + id);
        }
        if (restEntity.getExternalUrl() != null && !restEntity.getExternalUrl().equals(entityInDb.getExternalUrl())) {
            this.validateRepositoryWithExternalURLDoesNotExist(restEntity.getExternalUrl(), id);
        }
    }

    private SCMRepository createSCMRepositoryFromValues(String externalScmUrl, String internalScmUrl, boolean preBuildSyncEnabled) {
        RepositoryConfiguration.Builder built = RepositoryConfiguration.Builder.newBuilder().internalUrl(internalScmUrl).preBuildSyncEnabled(preBuildSyncEnabled);
        if (externalScmUrl != null) {
            built.externalUrl(externalScmUrl);
        }
        RepositoryConfiguration entity = (RepositoryConfiguration)this.repository.save((GenericEntity)built.build());
        log.info("Created SCM repository: {}.", (Object)entity.toString());
        return (SCMRepository)this.mapper.toDTO((GenericEntity)entity);
    }

    public void validateInternalRepository(String internalRepoUrl) throws InvalidEntityException {
        String internalScmAuthority = this.config.getInternalScmAuthority();
        if (!SCMRepositoryProviderImpl.isInternalRepository(internalScmAuthority, internalRepoUrl).booleanValue()) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Internal repository url has to start with: <protocol>://" + internalScmAuthority + " followed by a repository name or match the pattern: " + REPOSITORY_NAME_PATTERN);
        }
        if (internalRepoUrl.contains("/gerrit/")) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Incorrect format of internal repository. Internal repository url should not contain '/gerrit/' part of the url");
        }
        if (internalRepoUrl.split("://")[0].contains("http")) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Incorrect url protocol. Http and https protocols are not supported for internal repository. Try using 'git+ssh'");
        }
    }

    public static Boolean isInternalRepository(String internalScmAuthority, String internalRepoUrl) {
        if (StringUtils.isEmpty((String)internalRepoUrl) || internalScmAuthority == null) {
            throw new IllegalArgumentException("InternalScmAuthority and internalRepoUrl parameters must be set.");
        }
        String internalRepoUrlNoProto = UrlUtils.stripProtocol((String)internalRepoUrl);
        String internalRepoName = internalRepoUrlNoProto.replace(internalScmAuthority, "");
        return internalRepoUrlNoProto.startsWith(internalScmAuthority) && REPOSITORY_NAME_PATTERN.matcher(internalRepoName).matches();
    }

    private void validateRepositoryWithInternalURLDoesNotExist(String internalUrl, Integer ignoreId) throws ConflictedEntryException {
        RepositoryConfiguration repositoryConfiguration = this.repositoryConfigurationRepository.queryByInternalScm(internalUrl);
        if (repositoryConfiguration != null && !repositoryConfiguration.getId().equals(ignoreId)) {
            String message = "SCM Repository already exists (id: " + repositoryConfiguration.getId() + ")";
            throw new ConflictedEntryException(message, RepositoryConfiguration.class, repositoryConfiguration.getId().toString());
        }
    }

    private void validateRepositoryWithExternalURLDoesNotExist(String externalUrl, Integer ignoreId) throws ConflictedEntryException {
        RepositoryConfiguration repositoryConfiguration = this.repositoryConfigurationRepository.queryByExternalScm(externalUrl);
        if (repositoryConfiguration != null && !repositoryConfiguration.getId().equals(ignoreId)) {
            String message = "SCM Repository already exists (id: " + repositoryConfiguration.getId() + ")";
            throw new ConflictedEntryException(message, RepositoryConfiguration.class, repositoryConfiguration.getId().toString());
        }
        String internalUrl = this.repour.translateExternalUrl(externalUrl);
        this.validateRepositoryWithInternalURLDoesNotExist(internalUrl, ignoreId);
    }

    private Integer startRCreationTask(String externalURL, boolean preBuildSyncEnabled, JobNotificationType jobType, Consumer<SCMRepositoryProvider.RepositoryCreated> consumer, Optional<BuildConfiguration> buildConfiguration) {
        RepositoryCreationTask task;
        String userToken = this.userService.currentUserToken();
        org.jboss.pnc.bpm.model.RepositoryConfiguration repositoryConfiguration = org.jboss.pnc.bpm.model.RepositoryConfiguration.builder().externalUrl(externalURL).preBuildSyncEnabled(Boolean.valueOf(preBuildSyncEnabled)).build();
        if (this.bpmConfig.isNewBpmForced() || this.userService.hasLoggedInUserRole("work-with-tech-preview")) {
            RepositoryCreationProcess.RepositoryCreationProcessBuilder repositoryCreationProcess = RepositoryCreationProcess.builder().repositoryConfiguration(repositoryConfiguration);
            buildConfiguration.ifPresent(bc -> repositoryCreationProcess.buildConfiguration(bc));
            task = new RepositoryCreationTask(repositoryCreationProcess.build(), userToken);
            task.setTaskId(this.bpmManager.getNextTaskId());
            task.setGlobalConfig(this.globalConfig);
            task.setJsonEncodedProcessParameters(false);
            task.setJobType(jobType);
            RestConnector restConnector = new RestConnector(this.bpmConfig);
            try {
                Map processParameters = task.getExtendedProcessParameters();
                restConnector.startProcess(this.bpmConfig.getNewBcCreationProcessId(), (Object)processParameters, userToken);
            }
            catch (CoreException e) {
                throw new RuntimeException("Could not get process parameters: " + task, e);
            }
            catch (ProcessManagerException e) {
                throw new RuntimeException("Could not start BPM task using REST connector: " + task, e);
            }
        }
        RepositoryCreationProcess repositoryCreationProcess = RepositoryCreationProcess.builder().repositoryConfiguration(repositoryConfiguration).build();
        task = new RepositoryCreationTask(repositoryCreationProcess, userToken);
        task.setJobType(jobType);
        Consumer<RepositoryCloneSuccess> successListener = event -> this.onRepoCloneSuccess(event.getData().getInternalUrl(), task.getTaskId(), consumer, jobType, externalURL, preBuildSyncEnabled);
        task.addListener(BpmEventType.RC_REPO_CLONE_SUCCESS, MDCWrappers.wrap(successListener));
        this.addErrorListeners(jobType, task);
        try {
            this.bpmManager.startTask((BpmTask)task);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not start BPM task: " + task, e);
        }
        return task.getTaskId();
    }

    @Override
    public void repositoryCreationCompleted(RepositoryCreationResult result) {
        if (result.getStatus().isSuccess()) {
            Consumer<SCMRepositoryProvider.RepositoryCreated> onRepositoryCreated = event -> {
                log.debug("Repository created: {}", event);
                if (result.getJobType().equals((Object)JobNotificationType.BUILD_CONFIG_CREATION)) {
                    this.buildConfigurationProvider.createBuildConfigurationWithRepository(result.getTaskId().toString(), event.getRepositoryId(), result.getBuildConfiguration());
                }
                this.notifySCMRepositoryCreated((SCMRepositoryProvider.RepositoryCreated)event);
            };
            this.onRepoCloneSuccess(result.getInternalScmUrl(), result.getTaskId(), onRepositoryCreated, result.getJobType(), result.getExternalUrl(), result.isPreBuildSyncEnabled());
        } else {
            String eventType = !result.isRepoCreatedSuccessfully() ? BpmEventType.RC_REPO_CREATION_ERROR.toString() : BpmEventType.RC_REPO_CLONE_ERROR.toString();
            org.jboss.pnc.bpm.model.RepositoryConfiguration repositoryConfiguration = org.jboss.pnc.bpm.model.RepositoryConfiguration.builder().externalUrl(result.getExternalUrl()).preBuildSyncEnabled(Boolean.valueOf(result.isPreBuildSyncEnabled())).build();
            RepositoryCreationProcess repositoryCreationProcess = RepositoryCreationProcess.builder().repositoryConfiguration(repositoryConfiguration).build();
            this.notifier.sendMessage((Object)new RepositoryCreationFailure(result.getJobType(), eventType, (Object)repositoryCreationProcess, result.getTaskId().toString()));
        }
    }

    private void onRepoCloneSuccess(String internalScmUrl, Integer taskId, Consumer<SCMRepositoryProvider.RepositoryCreated> consumer, JobNotificationType jobType, String externalURL, boolean preBuildSyncEnabled) {
        RepositoryConfiguration existing = (RepositoryConfiguration)this.repository.queryByPredicates(new Predicate[]{RepositoryConfigurationPredicates.withExactInternalScmRepoUrl((String)internalScmUrl)});
        if (existing != null) {
            RepositoryCreationFailure error = new RepositoryCreationFailure(jobType, RC_REPO_CREATION_CONFLICT, (Object)existing, taskId.toString());
            this.notifier.sendMessage((Object)error);
        } else {
            SCMRepository scmRepo = this.createSCMRepositoryFromValues(externalURL, internalScmUrl, preBuildSyncEnabled);
            SCMRepositoryProvider.RepositoryCreated notification = new SCMRepositoryProvider.RepositoryCreated(taskId, Integer.parseInt(scmRepo.getId()));
            consumer.accept(notification);
        }
    }

    private void addErrorListeners(JobNotificationType jobType, RepositoryCreationTask task) {
        Consumer doNotifySMNError = MDCWrappers.wrap(e -> this.notifier.sendMessage((Object)this.mapError(jobType, (BpmStringMapNotificationRest)e, task.getTaskId() == null ? null : task.getTaskId().toString())));
        task.addListener(BpmEventType.RC_REPO_CREATION_ERROR, doNotifySMNError);
        task.addListener(BpmEventType.RC_REPO_CLONE_ERROR, doNotifySMNError);
    }

    private RepositoryCreationFailure mapError(JobNotificationType jobType, BpmStringMapNotificationRest notification, String taskId) {
        log.debug("Received BPM event error: " + notification);
        return new RepositoryCreationFailure(jobType, notification.getEventType(), (Object)notification.getData(), taskId);
    }
}

