/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util;

import java.io.Serializable;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class HibernateLazyInitializer {
    private static final Logger log = LoggerFactory.getLogger(HibernateLazyInitializer.class);
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;

    @TransactionAttribute(value=TransactionAttributeType.MANDATORY)
    public BuildConfiguration initializeBuildConfigurationBeforeTriggeringIt(BuildConfiguration buildConfiguration) {
        log.trace("Initializing BC {}.", (Object)buildConfiguration.getId());
        buildConfiguration.getDependencies();
        buildConfiguration.getIndirectDependencies();
        ProductVersion productVersion = buildConfiguration.getProductVersion();
        if (productVersion != null) {
            productVersion.getProduct();
            productVersion.getCurrentProductMilestone();
        }
        return buildConfiguration;
    }

    @TransactionAttribute(value=TransactionAttributeType.MANDATORY)
    public BuildConfigurationAudited initializeBuildConfigurationAuditedBeforeTriggeringIt(BuildConfigurationAudited buildConfigurationAudited) {
        log.trace("Initializing BCA {}.", (Object)buildConfigurationAudited.getIdRev());
        buildConfigurationAudited.setBuildConfiguration((BuildConfiguration)this.buildConfigurationRepository.queryById((Serializable)buildConfigurationAudited.getId()));
        this.initializeBuildConfigurationBeforeTriggeringIt(buildConfigurationAudited.getBuildConfiguration());
        return buildConfigurationAudited;
    }

    @TransactionAttribute(value=TransactionAttributeType.MANDATORY)
    public BuildConfigurationSet initializeBuildConfigurationSetBeforeTriggeringIt(BuildConfigurationSet bcs) {
        log.trace("Initializing {} build configurations in set {}.", (Object)bcs.getBuildConfigurations().size(), (Object)bcs.getId());
        bcs.getBuildConfigurations().stream().forEach(this::initializeBuildConfigurationBeforeTriggeringIt);
        return bcs;
    }
}

